#pragma once

#include <ozo/query_conf.h>

#include <boost/hana/tuple.hpp>

#include <fstream>

namespace collie::services::db {

template <class ... Queries>
auto makeQueryRepository(const std::string& path) {
    using namespace std::string_literals;

    namespace hana = boost::hana;

    std::ifstream file(path);

    if (!file.is_open()) {
        throw std::runtime_error("Can't open query conf file \""s + path + "\"");
    }

    std::noskipws(file);

    const std::string text {std::istreambuf_iterator<char>(file), std::istreambuf_iterator<char>()};

    if (file.bad() || file.fail()) {
        throw std::runtime_error("Error when read query conf file \""s + path + "\""s);
    }

    try {
        return ozo::make_query_repository(text, hana::tuple<Queries ...>());
    } catch (const std::exception& e) {
        throw std::runtime_error("Failed to make query repository from file \""s + path + "\": "s + e.what());
    }
}

} // namespace collie::services::db
