#pragma once

#include <src/logic/error.hpp>

#include <ozo/error.h>
#include <ozo/query_conf.h>
#include <sharpei_client/errors.h>

#include <stdexcept>
#include <string>

namespace collie::services::db {

template <class Range>
decltype(auto) expectSingleRow(Range&& range) {
    using namespace std::string_literals;
    if (std::size(range) == 1u) {
        return std::move(*std::begin(range));
    }
    throw std::runtime_error("expected single row, got "s + std::to_string(std::size(range)));
}

static inline bool userNotFound(const ozo::error_code& errorCode) {
    return (errorCode == ::sharpei::client::Errors::UidNotFound) ||
            (errorCode == collie::logic::Error::userNotFound);
}

} // namespace collie::services::db
