#pragma once

#include "types.hpp"

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::services::directory {

struct GetLastEventParams {
    OrgId orgId;
    Revision syncedRevision;
};

struct DirectoryClient {
    virtual ~DirectoryClient() = default;

    virtual expected<std::optional<Event>> getLastEvent(const TaskContextPtr& context,
            const GetLastEventParams& params) const = 0;
    virtual expected<OrgInfo> getOrgInfo(const TaskContextPtr& context, OrgId orgId) const = 0;
    virtual expected<Users> getUsers(const TaskContextPtr& context, OrgId orgId) const = 0;
    virtual expected<Departments> getDepartments(const TaskContextPtr& context, OrgId orgId) const = 0;
    virtual expected<Groups> getGroups(const TaskContextPtr& context, OrgId orgId) const = 0;
    virtual expected<Organizations> getOrganizations(const TaskContextPtr& context) const = 0;
};

using DirectoryClientPtr = std::shared_ptr<const DirectoryClient>;

} // namespace collie::services::directory
