#pragma once

#include "directory_client.hpp"
#include "config.hpp"

#include <src/services/utils.hpp>
#include <http_getter/http_request.h>

namespace collie::services::directory {

template <class T>
struct Page {
    T values;
    std::optional<std::string> next;
    std::optional<std::string> last;
};

using EventsPage = Page<Events>;
using UsersPage = Page<Users>;
using DepartmentsPage = Page<Departments>;
using GroupsPage = Page<Groups>;

struct Links {
    std::optional<std::string> next;
    std::optional<std::string> last;
};

struct OrganizationsResponse {
    Links links;
    Organizations result;
};

class DirectoryClientImpl : public DirectoryClient {
public:
    DirectoryClientImpl(const Config config, const GetHttpClient& getHttpClient,
            const GetTvm2Module& getTvm2Module);
    expected<std::optional<Event>> getLastEvent(const TaskContextPtr& context,
            const GetLastEventParams& params) const override;
    expected<OrgInfo> getOrgInfo(const TaskContextPtr& context, OrgId orgId) const override;
    expected<Users> getUsers(const TaskContextPtr& context, OrgId orgId) const override;
    expected<Departments> getDepartments(const TaskContextPtr& context, OrgId orgId) const override;
    expected<Groups> getGroups(const TaskContextPtr& context, OrgId orgId) const override;
    expected<Organizations> getOrganizations(const TaskContextPtr& context) const override;

private:
    expected<std::optional<Event>> getLastEvent(const TaskContextPtr& context,
            const GetLastEventParams& params, const std::string& serviceTicket) const;
    expected<OrgInfo> getOrgInfo(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket) const;
    expected<Users> getUsers(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket) const;
    expected<Departments> getDepartments(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket) const;
    expected<Groups> getGroups(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket) const;
    expected<EventsPage> getEvents(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket, std::string url) const;
    expected<UsersPage> getUsers(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket, std::string url) const;
    expected<DepartmentsPage> getDepartments(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket, std::string url) const;
    expected<GroupsPage> getGroups(const TaskContextPtr& context, OrgId orgId,
            const std::string& serviceTicket, std::string url) const;
    expected<OrganizationsResponse> getOrganizations(const TaskContextPtr& context,
            const std::string& serviceTicket, const std::string& url) const;
    expected<std::string> getTvmServiceTicket(const TaskContextPtr& context) const;
    expected<yhttp::response> perform(const TaskContextPtr& context, const http_getter::Request& request) const;
    Config config;
    GetHttpClient getHttpClient;
    GetTvm2Module getTvm2Module;
};

} // namespace collie::services::directory
