#pragma once


#include <boost/serialization/strong_typedef.hpp>

#include <optional>
#include <string>
#include <vector>

namespace collie::services::directory {

BOOST_STRONG_TYPEDEF(std::int64_t, OrgId);
BOOST_STRONG_TYPEDEF(std::int64_t, Revision);

struct Event {
    std::string name;
    std::string timestamp;
    std::string object_type;
    std::int64_t id;
    std::int64_t revision;
};

struct Name {
    std::optional<std::string> first;
    std::optional<std::string> last;
};

struct Contact {
    std::optional<std::string> type;
    std::optional<std::string> value;
};

struct Parent {
    std::optional<std::int64_t> id;
};

struct User {
    struct Department {
        std::int64_t id;
    };

    std::int64_t id;
    std::optional<Name> name;
    std::optional<std::vector<Contact>> contacts;
    std::optional<std::string> birthday;
    std::optional<Department> department;
    std::optional<std::string> position;
};

struct Department {
    std::int64_t id;
    std::optional<std::string> description;
    std::optional<std::string> email;
    std::optional<Parent> parent;
    std::optional<std::string> name;
};

struct Group {
    std::int64_t id;
    std::optional<std::string> description;
    std::optional<std::string> email;
    std::optional<std::string> name;
    std::optional<std::string> type;
};

struct Organization {
    OrgId id;
};

struct OrgInfo {
    std::optional<std::string> name;
};

using Events = std::vector<Event>;
using Users = std::vector<User>;
using Departments = std::vector<Department>;
using Groups = std::vector<Group>;
using Organizations = std::vector<Organization>;

} // namespace collie::services::directory
