#pragma once

#include <src/error_code.hpp>

namespace collie::services {

enum class Error {
    ok,
    httpError,
    invalidUrl
};

} // namespace collie::services

namespace boost::system {

template <>
struct is_error_code_enum<collie::services::Error> : std::true_type {};

} // namespace boost::system

namespace collie::services {

class ErrorCategory final : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "collie::services::ErrorCategory";
    }

    std::string message(int value) const override {
        switch (static_cast<Error>(value)) {
            case Error::ok:
                return "ok";
            case Error::httpError:
                return "http error";
            case Error::invalidUrl:
                return "invaild url";
        }
        return "unknown error code: " + std::to_string(value);
    }

    static const ErrorCategory& instance() {
        static const ErrorCategory errorCategory;
        return errorCategory;
    }
};

inline error_code::base_type make_error_code(Error ec) {
    return error_code::base_type(static_cast<int>(ec), ErrorCategory::instance());
}

} // namespace collie::services
