#pragma once

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::services::ml {

using MlId = std::int64_t;
struct MlEntry {
    MlId id;
    std::string email;
    std::optional<std::string> name;
};

using MlEntries = std::vector<MlEntry>;
struct MlClient {
    virtual ~MlClient() = default;
    virtual expected<MlEntries> getMlEntries(const TaskContextPtr& context) = 0;
};

using MlClientPtr = std::shared_ptr<MlClient>;

} // namespace collie::services::ml
