#pragma once

#include "ml_client.hpp"
#include "config.hpp"

#include <src/services/utils.hpp>
#include <http_getter/http_request.h>

namespace collie::services::ml {

struct MlEntriesResponse {
    MlEntries maillists;
};

class MlClientImpl : public MlClient {
public:
    MlClientImpl(const Config& config, const GetHttpClient& getHttpClient,
            const GetTvm2Module& getTvm2Module);
    virtual expected<MlEntries> getMlEntries(const TaskContextPtr& context) override;
private:
    expected<MlEntriesResponse> getMlEntriesImpl(const TaskContextPtr& context,
            const std::string& ticket) const;
    expected<std::string> getTvmServiceTicket(const TaskContextPtr& context) const;
    expected<yhttp::response> perform(const TaskContextPtr& context, const http_getter::Request& request) const;

    Config config;
    GetHttpClient getHttpClient;
    GetTvm2Module getTvm2Module;
};

} // namespace collie::services::ml
