#pragma once

#include "settings_client.hpp"

#include <src/services/utils.hpp>
#include <http_getter/http_request.h>

namespace collie::services::settings {

using namespace boost::hana::literals;

class SettingsClientImpl final : public SettingsClient {
public:
    SettingsClientImpl(const GetClusterClient& getHttpClient, const GetTvm2Module& getTvm2Module);

    expected<bool> getCollectAddressesField(const TaskContextPtr& context, const Uid& uid) const override;

private:
    using Response = yhttp::response;

    expected<std::string> getTvmServiceTicket(const TaskContextPtr& context) const;

    expected<Response> performWithRetries(
        const TaskContextPtr& context,
        const http_getter::Request& request,
        const Uid& uid) const;

    expected<bool> parseGetCollectAddressesFieldResult(const Response& response) const;

    GetClusterClient getHttpClient;
    GetTvm2Module getTvm2Module;
};

} //collie::services::settings