#include "sharpei_http_client.hpp"

#include <butil/http/arguments.h>
#include <butil/http/headers.h>

namespace collie::services::sharpei {

void SharpeiHttpClient::aget(const Address& addr, Timeout timeout, const std::string& method,
        const Arguments& args, const Headers& headers, ResponseHandler handler, bool keepAlive,
        const std::string& requestId) const {
    using ::sharpei::client::http::Response;
    using namespace http_getter;
    using namespace std::chrono_literals;
    const auto toYplatformDuration = [](auto v) { 
        return yplatform::time_traits::duration_cast<yplatform::time_traits::duration>(v);
    };

    const auto request = get("http://" + addr.host + ":" + std::to_string(addr.port) + method + "?")
                        .getArgs("args"_arg=HttpArguments{args})
                        .headers("hdrs"_hdr=http::headers{headers})
                        .keepAlive(keepAlive)
                        .timeouts(toYplatformDuration(timeout), connectTimeout)
                        .make();
    http_getter::asyncRun(
        *getHttpClient(),
        boost::make_shared<yplatform::task_context>(requestId),
        request,
        [handler = std::move(handler)] (const auto& ec, auto response) {
            if (ec) {
                return handler(ec, Response {0, ""});
            }
            handler(ec, Response {
                static_cast<unsigned>(response.status),
                std::move(response.body)
            });
        }
    );
}

void SharpeiHttpClient::apost(const Address&, Timeout, const std::string&, const Arguments&,
        const Headers&, const std::string&, ResponseHandler, bool, const std::string&) const {
    throw std::logic_error("SharpeiHttpClient::apost is not implemented");
}

} // namespace collie::services::sharpei
