#pragma once

#include <sharpei_client/http.h>

#include <src/services/utils.hpp>
#include <http_getter/http_request.h>

namespace collie::services::sharpei {

using ::sharpei::client::http::HttpClient;
using ::sharpei::client::http::Address;
using ::sharpei::client::http::Arguments;
using ::sharpei::client::http::Headers;
using ::sharpei::client::http::ResponseHandler;
using ::sharpei::client::http::Timeout;

class SharpeiHttpClient final : public HttpClient {
public:
    SharpeiHttpClient(GetHttpClient getHttpClient, yplatform::time_traits::duration connectTimeout)
        : getHttpClient(std::move(getHttpClient)), connectTimeout(connectTimeout) {
    }

    void aget(const Address& addr, Timeout timeout, const std::string& method, const Arguments& args,
            const Headers& headers, ResponseHandler handler, bool keepAlive,
            const std::string& requestId) const override;

    void apost(const Address& addr, Timeout timeout, const std::string& method, const Arguments& args,
            const Headers& headers, const std::string& data, ResponseHandler handler, bool keepAlive,
            const std::string& requestId) const override;

private:
    GetHttpClient getHttpClient;
    yplatform::time_traits::duration connectTimeout;
};

using SharpeiHttpClientPtr = ::sharpei::client::http::HttpClientPtr;

} // namespace collie::services::sharpei
