#pragma once

#include <src/logic/interface/types/uid.hpp>
#include <src/logic/interface/types/carddav_vcard_transforms.hpp>

#include <src/task_context.hpp>

namespace collie::services::sheltie {

using MapUriVcardJson = logic::MapUriVcardJson;
using MapUriVcardRfc = logic::MapUriVcardRfc;
using Uid = logic::Uid;

struct SheltieClient {
    virtual MapUriVcardRfc toVcard(
        const TaskContextPtr& context,
        const Uid& uid,
        const MapUriVcardJson& vcardsAsJson
    ) const = 0;

    virtual std::string fromVcard(
        const TaskContextPtr& context,
        const Uid& uid,
        std::string vcardAsRfc
    ) const = 0;

    virtual ~SheltieClient() = default;
};

} // collie::services::sheltie
