#pragma once

#include "sheltie_client.hpp"

#include <src/services/utils.hpp>
#include <http_getter/http_request.h>

namespace collie::services::sheltie {

class SheltieClientImpl final : public SheltieClient {
public:
    SheltieClientImpl(const GetClusterClient& getHttpClient);

    MapUriVcardRfc toVcard(
        const TaskContextPtr& context,
        const Uid& uid,
        const MapUriVcardJson& vcardsAsJson
    ) const override;

    std::string fromVcard(
        const TaskContextPtr& context,
        const Uid& uid,
        std::string vcardAsRfc
    ) const override;

private:
    using Response = yhttp::response;

    GetClusterClient getHttpClient;

    Response performWithRetries(const TaskContextPtr& context, const http_getter::Request& request) const;
};

} //collie::services::sheltie
