#pragma once

#include <src/expected.hpp>
#include <src/task_context.hpp>

namespace collie::services::staff {

struct Position {
    std::optional<std::string> ru;
};

struct Official {
    bool is_dismissed;
    std::optional<Position> position;
};

struct Personal {
    std::optional<std::string> about;
    std::optional<std::string> birthday;
};

struct NamePart {
    std::string ru;
};

struct Name {
    NamePart first;
    std::string middle;
    NamePart last;
};

struct Account {
    std::optional<std::string> type;
    std::optional<std::string> value;
};

struct Phone {
    std::optional<std::string> number;
    std::optional<std::string> type;
};

using StaffId = std::int64_t;
using Uid = std::int64_t;
using Accounts = std::vector<Account>;
using Phones = std::vector<Phone>;
struct Person {
    StaffId id;
    Name name;
    Official official;
    std::optional<Personal> personal;
    Uid uid;
    std::optional<std::string> work_email;
    std::optional<std::string> work_phone;
    std::optional<Accounts> accounts;
    std::optional<Phones> phones;
};

using Persons = std::vector<Person>;
struct StaffClient {
    virtual ~StaffClient() = default;
    virtual expected<Persons> getPersons(const TaskContextPtr& context) = 0;
};

using StaffClientPtr = std::shared_ptr<StaffClient>;

} // namespace collie::services::staff
