#pragma once

#include "staff_client.hpp"
#include "config.hpp"

#include <src/services/utils.hpp>
#include <http_getter/http_request.h>

namespace collie::services::staff {

struct Links {
    std::optional<std::string> next;
};

struct PersonsResponse {
    Links links;
    Persons result;
};

class StaffClientImpl : public StaffClient {
public:
    StaffClientImpl(const Config& config, const GetHttpClient& getHttpClient,
            const GetTvm2Module& getTvm2Module);
    virtual expected<Persons> getPersons(const TaskContextPtr& context) override;
private:
    expected<PersonsResponse> getPersonsImpl(const TaskContextPtr& context) const;
    expected<std::string> getTvmServiceTicket(const TaskContextPtr& context) const;
    expected<yhttp::response> perform(const TaskContextPtr& context, const http_getter::Request& request) const;

    Config config;
    GetHttpClient getHttpClient;
    GetTvm2Module getTvm2Module;
    std::optional<std::string> nextPersonsRequestUrl;
    std::optional<std::string> tvmServiceTicket;
};

} // namespace collie::services::staff
