#include "utils.hpp"

#include <yplatform/find.h>

namespace collie::services {

GetHttpClient makeGetHttpClient(const std::string& module) {
    return [=] { return yplatform::find<yhttp::simple_call, std::shared_ptr>(module); };
}

GetClusterClient makeGetClusterClient(const std::string& module) {
    return [=] { return yplatform::find<ymod_httpclient::cluster_call, std::shared_ptr>(module); };
}

GetTvm2Module makeGetTvm2Module(const std::string& module) {
    return [=] { return yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>(module); };
}

} // namespace collie::services
