#pragma once

#include <src/error_code.hpp>
#include <src/expected.hpp>
#include <src/task_context.hpp>
#include <yamail/data/deserialization/yajl.h>
#include <ymod_httpclient/call.h>
#include <ymod_tvm/module.h>

namespace collie::services {

using GetHttpClient = std::function<std::shared_ptr<yhttp::simple_call> ()>;
using GetClusterClient = std::function<std::shared_ptr<ymod_httpclient::cluster_call> ()>;
using GetTvm2Module = std::function<std::shared_ptr<ymod_tvm::tvm2_module> ()>;

GetHttpClient makeGetHttpClient(const std::string& module);
GetClusterClient makeGetClusterClient(const std::string& module);
GetTvm2Module makeGetTvm2Module(const std::string& module);

template <typename Type, typename Error> collie::expected<Type> fromJson(const std::string& value,
        const TaskContextPtr& context, const std::string& source) {
    using yamail::data::deserialization::fromJson;
    using yamail::data::deserialization::json::json2ptree::optForceNull;
    using yamail::data::reflection::options;
    try {
        return fromJson<Type>(value, options(optForceNull));
    } catch (const std::exception& ex) {
        logException(context->logger(), ex, log::message="failed to parse " + source + " response",
                log::response_body=value);
        return make_unexpected(error_code(Error::responseParseError));
    }
}

} // namespace collie::services
