#pragma once

#include "types/id_map_types.hpp"

#include <src/expected.hpp>
#include <src/services/db/events_queue/types/id_map_element.hpp>
#include <src/services/db/execute.hpp>
#include <src/services/db/request.hpp>

#include <ozo/query_conf.h>

namespace collie::sync::common {

template<typename Connection> class IdMap {
public:
    explicit IdMap(Connection& connection)
        : connection(connection) {
    }

    template<typename Query> expected<void> addElements(std::vector<IdMapElement> elements) {
        Query query;
        query.elements = std::move(elements);
        return services::db::execute(connection, std::as_const(query)).bind([&] {
            LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                    log::query=ozo::get_query_name(query));
        });
    }

    template<typename Query> expected<void> deleteByKeyIds(std::vector<KeyId> ids) {
        Query query;
        query.ids = std::move(ids);
        return services::db::execute(connection, std::as_const(query)).bind([&] {
            LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                    log::query=ozo::get_query_name(query));
        });
    }

    template<typename Query> expected<std::vector<IdMapElement>> getElements() {
        Query query;
        return services::db::request(connection, std::as_const(query)).bind([&](auto&& rows) {
            LOGDOG_(services::db::unwrap(connection).context()->logger(), notice,
                    log::query=ozo::get_query_name(query));
            return std::move(rows);
        });
    }

private:
    Connection& connection;
};

} // namespace collie::sync::common
