#pragma once

#include "types/contacts_info.hpp"
#include "types/id_map_types.hpp"

#include <unordered_map>

namespace collie::sync::common {

std::vector<KeyId> getKeyIdsFromIdMapElements(const std::vector<IdMapElement>& idMapElements);
std::vector<ValueId> getValueIdsFromIdMapElements(const std::vector<IdMapElement>& idMapElements);


using ContactsInfoIdMap = std::unordered_map<ValueId, ContactInfo>;
ContactsInfoIdMap makeContactInfoIdMap(ContactsInfo& contactsInfo);

using ContactIdSearchMap = std::unordered_map<KeyId, ContactInfo>;
ContactIdSearchMap makeContactIdSearchMap(const std::vector<IdMapElement>& idMapElements, ContactsInfoIdMap& idMapContactsInfo);

std::vector<IdMapElement> getDbCorrectionData(
        std::vector<ValueId> contactIds,
        std::vector<IdMapElement> idMapElements,
        std::vector<ValueId>& contactIdsToDelete,
        std::vector<KeyId>& keyIdsToDelete);

} // namespace collie::sync::common
