#pragma once

#include <src/task_context.hpp>

namespace collie::sync::common {

class WorkerContext {
public:
    void setTaskContext(TaskContextPtr taskContextToSet) {
        taskContext = taskContextToSet;
    }

    TaskContextPtr getTaskContext() const {
        return taskContext;
    }

    const boost::asio::yield_context& yield() const {
        return taskContext->yield();
    }

    const RequestLogger& logger() const {
        return taskContext->logger();
    }

    bool mustStop() const {
        return stopWorker;
    }

    void stop() {
        stopWorker = true;
    }

private:
    TaskContextPtr taskContext;
    std::atomic_bool stopWorker{false};
};

using WorkerContextPtr = std::shared_ptr<WorkerContext>;

} // namespace collie::sync::common
