#include "run_worker.hpp"
#include "worker.hpp"

namespace collie::sync::ml {

RunWorker::RunWorker(
        const common::WorkerContextPtr& workerContext,
        MakeContactsConnectionProvider makeContactsConnectionProvider,
        MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider,
        MlClientPtr mlClient)
        : workerContext(workerContext)
        , makeContactsConnectionProvider(std::move(makeContactsConnectionProvider))
        , makeEventsQueueConnectionProvider(std::move(makeEventsQueueConnectionProvider))
        , mlClient(std::move(mlClient)) {
}

void RunWorker::operator()(boost::asio::yield_context yield, const Config& config) const {
    const auto id{yplatform::task_context().uniq_id()};
    const std::string userIp{"127.0.0.1"};
    const std::string clientType{"ml_sync_worker"};
    const auto taskContext{boost::make_shared<TaskContext>(id, id, userIp, clientType, yield)};
    workerContext->setTaskContext(taskContext);
    try {
        LOGDOG_(taskContext->logger(), notice, log::message=clientType + " is started");
        const Worker worker{workerContext, makeContactsConnectionProvider, makeEventsQueueConnectionProvider,
                mlClient, config};
        worker();
        LOGDOG_(taskContext->logger(), notice, log::message=clientType + " is stopped");
    } catch (const boost::coroutines::detail::forced_unwind&) {
        throw;
    } catch (const std::exception& ex) {
        logException(taskContext->logger(), ex);
    } catch (...) {
        LOGDOG_(taskContext->logger(), error, log::message=clientType + " unknown error");
    }
}

} // namespace collie::sync::ml
