#pragma once

#include "config.hpp"

#include <src/services/db/contacts/make_connection_provider.hpp>
#include <src/services/db/events_queue/make_connection_provider.hpp>
#include <src/services/ml/ml_client.hpp>
#include <src/sync/common/worker_context.hpp>

namespace collie::sync::ml {

class RunWorker {
public:
    using MakeContactsConnectionProvider = services::db::contacts::MakeConnectionProvider<
            services::db::contacts::WithCheckIsUserExists>;
    using MakeEventsQueueConnectionProvider = services::db::events_queue::MakeConnectionProvider;
    using MlClientPtr = services::ml::MlClientPtr;
    RunWorker(
            const common::WorkerContextPtr& workerContext,
            MakeContactsConnectionProvider makeContactsConnectionProvider,
            MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider,
            MlClientPtr mlClient);
    void operator()(boost::asio::yield_context yield, const Config& config) const;

private:
    common::WorkerContextPtr workerContext;
    MakeContactsConnectionProvider makeContactsConnectionProvider;
    MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider;
    MlClientPtr mlClient;
};

} // namespace collie::sync::ml
