#pragma once

#include "config.hpp"

#include <src/sync/common/types/time_types.hpp>
#include <src/sync/common/worker_context.hpp>
#include <yplatform/module.h>

#include <mutex>

namespace collie::sync::staff {

class Module : public yplatform::module {
public:
    Module(boost::asio::io_context& io, const yplatform::ptree& config);
    void start();
    void stop();

private:
    void scheduleSync();
    void sync();

    std::reference_wrapper<boost::asio::io_context> io;
    Config config;
    std::unique_ptr<boost::asio::executor_work_guard<boost::asio::io_context::executor_type>> guard;
    common::WorkerContextPtr workerContext;
    boost::asio::deadline_timer timer;
    common::TimeType syncTime;
    bool syncIsOngoing{false};
    std::recursive_mutex mutex;
};

} // namespace collie::sync::staff
