#pragma once

#include "config.hpp"

#include <src/services/db/contacts/make_connection_provider.hpp>
#include <src/services/db/events_queue/make_connection_provider.hpp>
#include <src/services/staff/staff_client.hpp>
#include <src/sync/common/worker_context.hpp>

namespace collie::sync::staff {

class RunWorker {
public:
    using MakeContactsConnectionProvider = services::db::contacts::MakeConnectionProvider<
            services::db::contacts::WithCheckIsUserExists>;
    using MakeEventsQueueConnectionProvider = services::db::events_queue::MakeConnectionProvider;
    using StaffClientPtr = services::staff::StaffClientPtr;
    RunWorker(
            const common::WorkerContextPtr& workerContext,
            MakeContactsConnectionProvider makeContactsConnectionProvider,
            MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider,
            StaffClientPtr staffClient);
    void operator()(boost::asio::yield_context yield, const Config& config) const;

private:
    common::WorkerContextPtr workerContext;
    MakeContactsConnectionProvider makeContactsConnectionProvider;
    MakeEventsQueueConnectionProvider makeEventsQueueConnectionProvider;
    StaffClientPtr staffClient;
};

} // namespace collie::sync::staff
