#include "module.hpp"

#include "config_reflection.hpp"

#include <yamail/data/deserialization/ptree.h>
#include <ymod_webserver/server.h>
#include <yplatform/module_registration.h>

namespace collie::sync::web {

void Module::init(const yplatform::ptree& configTree) {
    const auto config{yamail::data::deserialization::fromPtree<Config>(configTree)};
    auto webserver{yplatform::find<ymod_webserver::server, std::shared_ptr>(config.webServerModule)};

    const std::string endpointName;
    const std::string path{"/ping"};
    webserver->bind(endpointName, {path}, [](ymod_webserver::http::stream_ptr stream) {
        const std::string body{"pong"};
        stream->result(ymod_webserver::codes::code::ok, body);
    });
}

} // namespace collie::sync::web

DEFINE_SERVICE_OBJECT(collie::sync::web::Module)
