#pragma once

#include "log.hpp"

#include <yplatform/task_context.h>
#include <boost/asio/spawn.hpp>

namespace collie {

class TaskContext : public yplatform::task_context {
public:
    TaskContext(const std::string& uniqId, const std::string& requestId, const std::string& userIp,
            const std::string& clientType, const boost::asio::yield_context& yield)
        : yplatform::task_context(uniqId),
          requestId_(requestId),
          userIp_(userIp),
          clientType_(clientType),
          yield_(yield),
          logger_(getLogger(uniqId, requestId)) {
    }

    const std::string& requestId() const {
        return requestId_;
    }

    const std::string& userIp() const {
        return userIp_;
    }

    const std::string& clientType() const {
        return clientType_;
    }

    const boost::asio::yield_context& yield() const {
        return yield_;
    }

    const RequestLogger& logger() const {
        return logger_;
    }

private:
    std::string requestId_;
    std::string userIp_;
    std::string clientType_;
    boost::asio::yield_context yield_;
    RequestLogger logger_;
};

using TaskContextPtr = boost::shared_ptr<TaskContext>;

} // namespace collie
