#pragma once

#include <cstdint>
#include <optional>
#include <string>
#include <vector>

namespace collie {

struct EmailWithTags {
    std::optional<std::int64_t> id;
    std::optional<std::string> value;
    std::optional<std::vector<std::int64_t>> tags;
};

inline bool hasAtLeastOneEmail(const std::vector<EmailWithTags>& emails) {
    if (emails.size()) {
        for (const auto& email : emails) {
            if (email.value && email.value->size()) {
                return true;
            }
        }
    }
    return false;
}

} // namespace collie
