#pragma once

#include <src/directory_sync/event_queue/module_interface.hpp>
#include <src/logic/interface/types/vcard.hpp>
#include <yplatform/find.h>

#include <boost/property_tree/xml_parser.hpp>
#include <boost/range/algorithm_ext/erase.hpp>

#include <algorithm>
#include <sstream>
#include <vector>

namespace collie {

static inline boost::property_tree::ptree ptreeFromXml(const std::string& value) {
    try {
        boost::property_tree::ptree ptree;
        std::istringstream stream(value);
        boost::property_tree::xml_parser::read_xml(stream, ptree);
        return ptree;
    } catch (const std::exception& ex) {
        using namespace std::string_literals;
        throw std::runtime_error("failed to read XML ("s + ex.what() + ")");
    }
}

using GetEventQueueModule = std::function<std::shared_ptr<directory_sync::event_queue::ModuleInterface>()>;
static inline GetEventQueueModule makeGetEventQueueModule(const std::string& moduleName) {
    return [=]{return yplatform::find<directory_sync::event_queue::ModuleInterface, std::shared_ptr>(
            moduleName);};
}

template<typename Range> bool isInRange(const Range& range, const typename Range::value_type& value) {
    return std::any_of(range.begin(), range.end(), [&](const auto& element){return element == value;});
}

template<typename Range, typename Filter> void preprocessRange(std::optional<Range>& range,
        const Filter filter) {
    if (range) {
        boost::remove_erase_if(*range, std::move(filter));
        if (range->empty()) {
            range.reset();
        }
    }
}

static inline logic::Event makeBirthdayEvent(std::string date) {
    logic::Event result;
    std::int64_t year;
    std::int64_t month;
    std::int64_t day;
    if (!std::sscanf(date.c_str(), "%4ld-%2ld-%2ld", &year, &month, &day)) {
        throw std::runtime_error("Failed to parse birthday date");
    }
    result.year = year;
    result.month = month;
    result.day = day;
    result.type = std::vector<std::string>(1, "birthday");
    return result;
}

} // namespace collie
