LIBRARY(collie)

OWNER(
    ilya-sidorov
    vyserenity
    g:mail
)

NO_UTIL()

PEERDIR(
    mail/butil
    mail/logdog
    mail/mail_errors
    mail/ozo
    mail/pgg
    mail/sharpei_client
    mail/tvm_guard/ymod_tvm
    mail/yreflection
    mail/pa
    mail/ymod_httpclient
    mail/ymod_statserver
    mail/ymod_tvm
    mail/ymod_webserver
    mail/yplatform/lib
    mail/expected
    mail/mimeparser
    mail/mail_getter
    mail/http_getter
)

CFLAGS(
    -DBOOST_HANA_CONFIG_ENABLE_STRING_UDL
    -Wno-gnu-string-literal-operator-template
)

ADDINCL(
    GLOBAL mail/collie
)

SRCS(
    directory_sync/event_queue/config.hpp
    directory_sync/event_queue/config_reflection.hpp
    directory_sync/event_queue/error.hpp
    GLOBAL directory_sync/event_queue/module.cpp
    directory_sync/event_queue/module.hpp
    directory_sync/event_queue/module_interface.hpp
    directory_sync/event_queue/run_sync_event_queue.cpp
    directory_sync/event_queue/run_sync_event_queue.hpp
    directory_sync/event_queue/sync_event_queue.hpp
    directory_sync/event_queue/sync_event_queue_context.hpp
    directory_sync/types/user_to_sync.hpp
    GLOBAL directory_sync/module.cpp
    directory_sync/prepare_contacts.cpp
    directory_sync/run_worker.cpp
    directory_sync/workers_pool.cpp
    logic/db/contacts/acquire_revision.hpp
    logic/db/contacts/create_contacts.cpp
    logic/db/contacts/create_contacts.hpp
    logic/db/contacts/create_contacts_emails.hpp
    logic/db/contacts/create_contacts_list.hpp
    logic/db/contacts/create_contacts_user.hpp
    logic/db/contacts/create_directory_entities.hpp
    logic/db/contacts/delete_contacts_list.hpp
    logic/db/contacts/get_contact_ids_by_list_ids.hpp
    logic/db/contacts/get_contact_ids_by_tag_ids.hpp
    logic/db/contacts/get_contact_ids_tag_ids_by_contact_ids.hpp
    logic/db/contacts/get_contacts.hpp
    logic/db/contacts/get_contacts_by_tag_id.hpp
    logic/db/contacts/get_contacts_by_tag_name_and_tag_type_and_uris.hpp
    logic/db/contacts/get_contacts_count.hpp
    logic/db/contacts/get_contacts_email_ids_by_contacts_ids.hpp
    logic/db/contacts/get_contacts_email_ids_by_tag_ids.hpp
    logic/db/contacts/get_contacts_emails_by_tag_ids.hpp
    logic/db/contacts/get_contacts_ids_by_contacts_email_ids.hpp
    logic/db/contacts/get_default_list_id.hpp
    logic/db/contacts/get_directory_entities.hpp
    logic/db/contacts/get_email_ids_tag_ids_by_email_ids.hpp
    logic/db/contacts/get_shared_contacts.hpp
    logic/db/contacts/get_shared_contacts_count.hpp
    logic/db/contacts/get_shared_lists.hpp
    logic/db/contacts/get_subscribed_list_ids_by_owner.hpp
    logic/db/contacts/get_subscribed_list.hpp
    logic/db/contacts/get_subscribed_lists.hpp
    logic/db/contacts/get_tag_by_id.hpp
    logic/db/contacts/get_tag_id_by_tag_name_and_tag_type.hpp
    logic/db/contacts/get_user_type_lists.hpp
    logic/db/contacts/remove_contacts.hpp
    logic/db/contacts/remove_contacts_completely.hpp
    logic/db/contacts/remove_contacts_emails.hpp
    logic/db/contacts/remove_directory_entities.hpp
    logic/db/contacts/remove_tag.hpp
    logic/db/contacts/revoke_contacts_list.hpp
    logic/db/contacts/revoke_subscribed_contacts_list.hpp
    logic/db/contacts/share_contacts_list.hpp
    logic/db/contacts/subscribe_to_contacts.hpp
    logic/db/contacts/subscribe_to_contacts_list.hpp
    logic/db/contacts/tag_contacts.hpp
    logic/db/contacts/tag_contacts_and_contacts_emails.hpp
    logic/db/contacts/tag_contacts_emails.hpp
    logic/db/contacts/unsubscribe_from_contacts.hpp
    logic/db/contacts/untag_contacts.hpp
    logic/db/contacts/untag_contacts_and_contacts_emails.hpp
    logic/db/contacts/untag_contacts_completely.hpp
    logic/db/contacts/untag_contacts_emails.hpp
    logic/db/contacts/untag_contacts_emails_completely.hpp
    logic/db/contacts/update_contacts.cpp
    logic/db/contacts/update_contacts.hpp
    logic/db/contacts/update_contacts_emails.hpp
    logic/db/contacts/update_tag.hpp
    logic/db/contacts/utils.cpp
    logic/db/contacts/utils.hpp
    logic/db/events_queue/add_directory_events.hpp
    logic/db/add_directory_event_impl.hpp
    logic/db/add_emails_impl.hpp
    logic/db/carddav_delete_impl.hpp
    logic/db/carddav_multiget_impl.hpp
    logic/db/carddav_propfind_impl.hpp
    logic/db/carddav_put_impl.hpp
    logic/db/carddav_utils.hpp
    logic/db/carddav_utils.cpp
    logic/db/create_contacts_impl.hpp
    logic/db/create_tag_impl.hpp
    logic/db/get_changes_impl.hpp
    logic/db/get_contacts_count_impl.hpp
    logic/db/get_abook_format_contacts_impl.hpp
    logic/db/get_contacts_impl.hpp
    logic/db/get_contacts_with_tag_impl.hpp
    logic/db/get_emails_impl.hpp
    logic/db/get_shared_contacts_count_from_list_impl.hpp
    logic/db/get_shared_contacts_from_list_impl.hpp
    logic/db/get_shared_lists_impl.hpp
    logic/db/get_tags_impl.hpp
    logic/db/settings_client_ptr.hpp
    logic/db/shared_contacts_impl.hpp
    logic/db/sheltie_client_ptr.hpp
    logic/db/remove_contacts_impl.hpp
    logic/db/remove_tag_impl.hpp
    logic/db/restore_impl.hpp
    logic/db/update_tag_impl.hpp
    logic/db/sync_organizations_impl.hpp
    logic/db/utils.cpp
    logic/db/utils.hpp
    logic/interface/add_directory_event.hpp
    logic/interface/add_emails.hpp
    logic/interface/carddav_delete.hpp
    logic/interface/carddav_multiget.hpp
    logic/interface/carddav_propfind.hpp
    logic/interface/carddav_put.hpp
    logic/interface/create_contacts.hpp
    logic/interface/create_tag.hpp
    logic/interface/get_changes.hpp
    logic/interface/get_contacts.hpp
    logic/interface/get_abook_format_contacts.hpp
    logic/interface/get_contacts_with_tag.hpp
    logic/interface/get_emails.hpp
    logic/interface/get_shared_contacts_count_from_list.hpp
    logic/interface/get_shared_contacts_from_list.hpp
    logic/interface/get_shared_lists.hpp
    logic/interface/get_tags.hpp
    logic/interface/remove_contacts.hpp
    logic/interface/remove_tag.hpp
    logic/interface/restore.hpp
    logic/interface/update_contacts.hpp
    logic/interface/update_tag.hpp
    logic/interface/sync_organizations.hpp
    logic/interface/types/reflection/carddav_contact.hpp
    logic/interface/types/reflection/carddav_contact_info.hpp
    logic/interface/types/reflection/carddav_multiget_result.hpp
    logic/interface/types/reflection/carddav_propfind_result.hpp
    logic/interface/types/reflection/carddav_put_result.hpp
    logic/interface/types/reflection/change.cpp
    logic/interface/types/reflection/change.hpp
    logic/interface/types/reflection/changes.hpp
    logic/interface/types/reflection/created_contacts.hpp
    logic/interface/types/reflection/created_tag.hpp
    logic/interface/types/reflection/existing_contact.hpp
    logic/interface/types/reflection/existing_contacts.hpp
    logic/interface/types/reflection/existing_email.hpp
    logic/interface/types/reflection/existing_emails.hpp
    logic/interface/types/reflection/existing_shared_list.hpp
    logic/interface/types/reflection/existing_shared_lists.hpp
    logic/interface/types/reflection/existing_tag.cpp
    logic/interface/types/reflection/existing_tag.hpp
    logic/interface/types/reflection/existing_tags.hpp
    logic/interface/types/reflection/list_contacts_counter.hpp
    logic/interface/types/reflection/new_contact.hpp
    logic/interface/types/reflection/new_event.hpp
    logic/interface/types/reflection/new_event.cpp
    logic/interface/types/reflection/new_tag.hpp
    logic/interface/types/reflection/recipients.hpp
    logic/interface/types/reflection/updated_contact.hpp
    logic/interface/types/reflection/updated_contacts.hpp
    logic/interface/types/reflection/updated_tag.hpp
    logic/interface/types/reflection/vcard.hpp
    logic/interface/types/carddav_contact.hpp
    logic/interface/types/carddav_contact_info.hpp
    logic/interface/types/carddav_multiget_result.hpp
    logic/interface/types/carddav_propfind_result.hpp
    logic/interface/types/carddav_put_result.hpp
    logic/interface/types/carddav_vcard_transforms.hpp
    logic/interface/types/change.hpp
    logic/interface/types/changes.hpp
    logic/interface/types/contact_id.hpp
    logic/interface/types/created_contacts.hpp
    logic/interface/types/created_emails.hpp
    logic/interface/types/created_list.hpp
    logic/interface/types/created_tag.hpp
    logic/interface/types/directory_entity.hpp
    logic/interface/types/directory_entity_id.hpp
    logic/interface/types/directory_entity_id_and_type.hpp
    logic/interface/types/directory_entity_type.hpp
    logic/interface/types/directory_entry_id.hpp
    logic/interface/types/email_id.hpp
    logic/interface/types/event_type.hpp
    logic/interface/types/existing_contact.hpp
    logic/interface/types/existing_contacts.hpp
    logic/interface/types/existing_email.hpp
    logic/interface/types/existing_emails.hpp
    logic/interface/types/existing_shared_list.hpp
    logic/interface/types/existing_shared_lists.hpp
    logic/interface/types/existing_tag.hpp
    logic/interface/types/existing_tags.hpp
    logic/interface/types/list_contacts_counter.hpp
    logic/interface/types/list_id.hpp
    logic/interface/types/new_contact.hpp
    logic/interface/types/new_event.hpp
    logic/interface/types/new_tag.hpp
    logic/interface/types/org_id.hpp
    logic/interface/types/recipients.hpp
    logic/interface/types/revision.hpp
    logic/interface/types/tag_id.hpp
    logic/interface/types/uid.hpp
    logic/interface/types/updated_contact.hpp
    logic/interface/types/updated_tag.hpp
    logic/interface/types/vcard.hpp
    logic/error.hpp
    logic/utils.hpp
    server/config.hpp
    server/error.hpp
    server/error_category.hpp
    server/parse_request_body.hpp
    server/respond.hpp
    server/server.cpp
    server/server.hpp
    server/status.hpp
    server/stream.hpp
    server/utils.cpp
    server/utils.hpp
    server/handlers/abook_colabook_feed_addrdb_handler.cpp
    server/handlers/abook_colabook_feed_addrdb_handler.hpp
    server/handlers/add_directory_event_handler.cpp
    server/handlers/add_directory_event_handler.hpp
    server/handlers/add_emails_handler.cpp
    server/handlers/add_emails_handler.hpp
    server/handlers/carddav_delete_handler.cpp
    server/handlers/carddav_delete_handler.hpp
    server/handlers/carddav_multiget_handler.cpp
    server/handlers/carddav_multiget_handler.hpp
    server/handlers/carddav_propfind_handler.cpp
    server/handlers/carddav_propfind_handler.hpp
    server/handlers/carddav_put_handler.cpp
    server/handlers/carddav_put_handler.hpp
    server/handlers/create_contacts_handler.cpp
    server/handlers/create_contacts_handler.hpp
    server/handlers/create_tag_handler.cpp
    server/handlers/create_tag_handler.hpp
    server/handlers/get_changes_handler.cpp
    server/handlers/get_changes_handler.hpp
    server/handlers/get_contacts_handler.cpp
    server/handlers/get_contacts_handler.hpp
    server/handlers/abook_search_contacts_handler.cpp
    server/handlers/abook_search_contacts_handler.hpp
    server/handlers/get_contacts_count_handler.cpp
    server/handlers/get_contacts_count_handler.hpp
    server/handlers/get_contacts_with_tag_handler.cpp
    server/handlers/get_contacts_with_tag_handler.hpp
    server/handlers/get_emails_handler.cpp
    server/handlers/get_emails_handler.hpp
    server/handlers/get_shared_contacts_count_from_list_handler.cpp
    server/handlers/get_shared_contacts_count_from_list_handler.hpp
    server/handlers/get_shared_contacts_from_list_handler.cpp
    server/handlers/get_shared_contacts_from_list_handler.hpp
    server/handlers/get_shared_lists_handler.cpp
    server/handlers/get_shared_lists_handler.hpp
    server/handlers/get_tags_handler.cpp
    server/handlers/get_tags_handler.hpp
    server/handlers/not_implemented.hpp
    server/handlers/parameters.hpp
    server/handlers/reflection/revision_result.hpp
    server/handlers/remove_contacts_handler.cpp
    server/handlers/remove_contacts_handler.hpp
    server/handlers/remove_tag_handler.cpp
    server/handlers/remove_tag_handler.hpp
    server/handlers/restore_handler.cpp
    server/handlers/restore_handler.hpp
    server/handlers/tvm_guarded.hpp
    server/handlers/update_contacts_handler.cpp
    server/handlers/update_contacts_handler.hpp
    server/handlers/update_tag_handler.cpp
    server/handlers/update_tag_handler.hpp
    server/handlers/sync_organizations_handler.hpp
    server/handlers/sync_organizations_handler.cpp
    server/router/binary_search.hpp
    server/router/error.hpp
    server/router/error_category.hpp
    server/router/router.hpp
    server/router/types.hpp
    services/config.hpp
    services/utils.cpp
    services/utils.hpp
    services/xml.hpp
    services/abook/types/cid.hpp
    services/abook/types/contact.hpp
    services/abook/types/name.hpp
    services/abook/types/tid.hpp
    services/abook/types/reflection/colabook_addp_result.hpp
    services/abook/types/reflection/contact.hpp
    services/abook/types/reflection/name.hpp
    services/abook/types/reflection/search_contacts_result.hpp
    services/db/contacts/types/reflection/carddav_contact_row.hpp
    services/db/contacts/types/reflection/change_row.hpp
    services/db/contacts/types/reflection/contact_email_id_row.hpp
    services/db/contacts/types/reflection/contact_id_tag_id_row.hpp
    services/db/contacts/types/reflection/contacts_email_with_tags.hpp
    services/db/contacts/types/reflection/create_contacts_email_result.hpp
    services/db/contacts/types/reflection/create_contacts_result.hpp
    services/db/contacts/types/reflection/created_list_row.hpp
    services/db/contacts/types/reflection/created_tag_row.hpp
    services/db/contacts/types/reflection/directory_entity.hpp
    services/db/contacts/types/reflection/directory_entity_id_and_type.hpp
    services/db/contacts/types/reflection/directory_entity_row.hpp
    services/db/contacts/types/reflection/email_id_tag_id_row.hpp
    services/db/contacts/types/reflection/existing_contact_row.hpp
    services/db/contacts/types/reflection/existing_email_row.hpp
    services/db/contacts/types/reflection/existing_shared_list_row.hpp
    services/db/contacts/types/reflection/existing_tag_row.hpp
    services/db/contacts/types/reflection/new_contact.hpp
    services/db/contacts/types/reflection/new_contacts_email.hpp
    services/db/contacts/types/reflection/shared_list_row.hpp
    services/db/contacts/types/reflection/subscribed_list.hpp
    services/db/contacts/types/reflection/updated_contact.hpp
    services/db/contacts/types/reflection/updated_contacts_email.hpp
    services/db/contacts/types/change_type.hpp
    services/db/contacts/types/contacts_email_with_tags.hpp
    services/db/contacts/types/create_contacts_email_result.hpp
    services/db/contacts/types/create_contacts_result.hpp
    services/db/contacts/types/create_contacts_user_result.hpp
    services/db/contacts/types/directory_entity.hpp
    services/db/contacts/types/directory_entity_id_and_type.hpp
    services/db/contacts/types/directory_entity_type.hpp
    services/db/contacts/types/list_type.hpp
    services/db/contacts/types/new_contact.hpp
    services/db/contacts/types/new_contacts_email.hpp
    services/db/contacts/types/tag_id.hpp
    services/db/contacts/types/tag_type.hpp
    services/db/contacts/types/updated_contact.hpp
    services/db/contacts/types/updated_contacts_email.hpp
    services/db/contacts/types/user_type.hpp
    services/db/contacts/types/subscribed_list.hpp
    services/db/contacts/types/vcard_format.hpp
    services/db/contacts/check_is_user_exists_operation.hpp
    services/db/contacts/config.hpp
    services/db/contacts/connection_provider.hpp
    services/db/contacts/endpoint_pool.hpp
    services/db/contacts/make_connection_provider.hpp
    services/db/contacts/oid_map.hpp
    services/db/contacts/query.hpp
    services/db/contacts/query_repository.hpp
    services/db/contacts/uid_to_connection_resolve_operation.hpp
    services/db/contacts/uid_to_connection_resolver.hpp
    services/db/config.hpp
    services/db/connection_provider.hpp
    services/db/endpoint_pool.hpp
    services/db/error.hpp
    services/db/timeouts.hpp
    services/db/events_queue/types/reflection/id_map_element.hpp
    services/db/events_queue/types/reflection/service_sync_timestamp_row.hpp
    services/db/events_queue/types/reflection/user_to_sync.hpp
    services/db/events_queue/types/directory_event_id.hpp
    services/db/events_queue/types/directory_revision.hpp
    services/db/events_queue/types/event_type.hpp
    services/db/events_queue/types/id_map_element.hpp
    services/db/events_queue/types/service_type.hpp
    services/db/events_queue/complete_sync_directory_event.hpp
    services/db/events_queue/complete_directory_organization_removal.hpp
    services/db/events_queue/config.hpp
    services/db/events_queue/connection_adaptor.hpp
    services/db/events_queue/connection_pool.hpp
    services/db/events_queue/connection_provider_config.hpp
    services/db/events_queue/connection_provider.hpp
    services/db/events_queue/credentials.cpp
    services/db/events_queue/credentials.hpp
    services/db/events_queue/endpoint_pool.hpp
    services/db/events_queue/get_user_to_sync.hpp
    services/db/events_queue/make_connection_provider.cpp
    services/db/events_queue/make_connection_provider.hpp
    services/db/events_queue/master_resolve_operation.hpp
    services/db/events_queue/master_resolver.hpp
    services/db/events_queue/oid_map.hpp
    services/db/events_queue/query.hpp
    services/db/events_queue/query_repository.hpp
    services/directory/directory_client_impl.cpp
    services/directory/utils.cpp
    services/directory/utils.hpp
    services/ml/config.hpp
    services/ml/error.hpp
    services/ml/ml_client.hpp
    services/ml/ml_client_impl.cpp
    services/ml/ml_client_impl.hpp
    services/settings/error.hpp
    services/settings/settings_client.hpp
    services/settings/settings_client_impl.hpp
    services/settings/settings_client_impl.cpp
    services/sharpei/config.hpp
    services/sharpei/sharpei_http_client.hpp
    services/sharpei/sharpei_http_client.cpp
    services/sheltie/sheltie_client.hpp
    services/sheltie/sheltie_client_impl.hpp
    services/sheltie/sheltie_client_impl.cpp
    services/staff/config.hpp
    services/staff/error.hpp
    services/staff/staff_client.hpp
    services/staff/staff_client_impl.cpp
    services/staff/staff_client_impl.hpp
    sync/common/types/id_map_types.hpp
    sync/common/types/time_types.hpp
    sync/common/id_map.hpp
    sync/common/service_sync.hpp
    sync/common/update_db.hpp
    sync/common/utils.cpp
    sync/common/utils.hpp
    sync/common/worker_context.hpp
    sync/ml/config.hpp
    sync/ml/config_reflection.hpp
    sync/ml/error.hpp
    GLOBAL sync/ml/module.cpp
    sync/ml/module.hpp
    sync/ml/run_worker.cpp
    sync/ml/run_worker.hpp
    sync/ml/worker.hpp
    sync/staff/config.hpp
    sync/staff/config_reflection.hpp
    sync/staff/error.hpp
    GLOBAL sync/staff/module.cpp
    sync/staff/module.hpp
    sync/staff/run_worker.cpp
    sync/staff/run_worker.hpp
    sync/staff/worker.hpp
    sync/web/config.hpp
    sync/web/config_reflection.hpp
    GLOBAL sync/web/module.cpp
    sync/web/module.hpp
    types/reflection/email_with_tags.hpp
    types/email_with_tags.hpp
    api.hpp
    config.hpp
    config_reflection.hpp
    error_code.hpp
    expected.hpp
    log.hpp
    GLOBAL module.cpp
    module.hpp
    task_context.hpp
    utils.hpp
)

END()
