from cpython cimport *

from libcpp.vector cimport vector
from libcpp.memory cimport make_shared
from libcpp.utility cimport move
from libcpp.string cimport string

from mail.unistat.cpp.cython.run_cpp cimport run as run_cpp
from mail.unistat.cpp.cython.logs cimport *

from meters cimport CountByPath as CountByPathImpl
from logs cimport (
    ServiceLog as ServiceLogImpl,
    ServiceLogMeters,
    Logs
)


cdef class CountByPath:
    cdef shared_ptr[CountByPathImpl] __impl
    def __cinit__(self, string reWithNamedCapGroups, string namePrefix, string nameSuffix):
        self.__impl = make_shared[CountByPathImpl](move(reWithNamedCapGroups), move(namePrefix), move(nameSuffix))


cdef class ServiceLog:
    cdef shared_ptr[ServiceLogImpl] __impl

    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        pm.reserve(len(pyMeters))
        for m in pyMeters:
            pm.push_back(<PyObject *>m)

        cdef vector[ServiceLogMeters] cm
        cm.reserve(len(cppMeters))
        for m in cppMeters:
            if isinstance(m, CountByPath):
                cm.push_back(ServiceLogMeters((<CountByPath>m).__impl))
            else:
                raise AttributeError("Unknown meter type for ServiceLog")
        self.__impl = make_shared[ServiceLogImpl](move(pm), move(cm), fastForward, <const char*>path)


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[Logs] cppLogs
    cppLogs.reserve(len(pyLogs))
    for l in pyLogs:
        if isinstance(l, AccessTskv):
            cppLogs.push_back(
                Logs((<AccessTskv>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                Logs((<HttpClientLog>l).__impl)
            )
        elif isinstance(l, SupervisorLog):
            cppLogs.push_back(
                Logs((<SupervisorLog>l).__impl)
            )
        elif isinstance(l, ServiceLog):
            cppLogs.push_back(
                Logs((<ServiceLog>l).__impl)
            )
        elif isinstance(l, TskvLog):
            cppLogs.push_back(
                Logs((<TskvLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")

    run_cpp(move(host), move(port), move(cppLogs), move(yplatformLogPath), move(logLevel))
