include(find_zipios_dependencies)

if(ZIPIOS_FOUND)
  set(ZIPIOS_FIND_QUIETLY TRUE)
endif()

find_path(ZIPIOS_INCLUDE_DIR
  NAMES zipios++/zipinputstream.h
  HINTS ${CMAKE_INSTALL_PREFIX}/include)

find_library(ZIPIOS_LIBRARY NAMES zipios++
  HINTS ${CMAKE_INSTALL_PREFIX}
  PATH_SUFFIXES .libs lib lib64)

find_zipios_dependencies()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(ZIPIOS DEFAULT_MSG
  ZIPIOS_INCLUDE_DIR ZIPIOS_LIBRARY)

if(ZIPIOS_FOUND)
  list(APPEND ZIPIOS_INCLUDE_DIR ${ZIPIOS_DEPENDENCY_INCLUDE_DIRS})
  list(APPEND ZIPIOS_LIBRARIES ${ZIPIOS_LIBRARY} ${ZIPIOS_DEPENDENCY_LIBRARIES})
endif()

mark_as_advanced(ZIPIOS_INCLUDE_DIR ZIPIOS_LIBRARIES)
