
#include "zipios++/zipios-config.h"

#include "zipios++/meta-iostreams.h"

#include "zipios++/fcollexceptions.h"

namespace zipios {

using std::cerr ;
using std::endl ;

IOException::IOException() noexcept 
  : _what( "I/O exception" ) {}

IOException::IOException( const string &msg ) noexcept 
  : _what( msg ) {}

IOException::IOException( const IOException &src ) noexcept 
  : std::exception(), _what( src._what ) {}


IOException &IOException::operator= ( const IOException &src ) noexcept {
  _what = src._what ;
  return *this ;
}

  
const char *IOException::what() const noexcept {
  return _what.c_str() ;
}

IOException::~IOException() {}






FCollException::FCollException() noexcept 
  : _what( "FileCollection exception" ) {}

FCollException::FCollException( const string &msg ) noexcept 
  : _what( msg ) {}

FCollException::FCollException( const FCollException &src ) noexcept 
  : std::exception(),_what( src._what ) {}


FCollException &FCollException::operator= ( const FCollException &src ) noexcept {
  _what = src._what ;
  return *this ;
}

  
const char *FCollException::what() const noexcept {
  return _what.c_str() ;
}

FCollException::~FCollException() {}






InvalidStateException::InvalidStateException() noexcept 
  : _what( "InvalidState exception" ) {}

InvalidStateException::InvalidStateException( const string &msg ) noexcept 
  : _what( msg ) {}

InvalidStateException::
InvalidStateException( const InvalidStateException &src ) noexcept 
  : std::exception(), _what( src._what ) {}


InvalidStateException &InvalidStateException::
operator= ( const InvalidStateException &src ) noexcept {
  _what = src._what ;
  return *this ;
}

  
const char *InvalidStateException::what() const noexcept {
  return _what.c_str() ;
}

InvalidStateException::~InvalidStateException() {} 





Exception::Exception() noexcept 
  : _what( "Exception" ) {}

Exception::Exception( const string &msg ) noexcept 
  : _what( msg ) {}

Exception::
Exception( const Exception &src ) noexcept 
  : std::exception(),_what( src._what ) {}


Exception &Exception::
operator= ( const Exception &src ) noexcept {
  _what = src._what ;
  return *this ;
}

  
const char *Exception::what() const noexcept {
  return _what.c_str() ;
}

Exception::~Exception() {} 


} // namespace

/** \file
    Implementation of a number of Exceptions used by FileCollection and its
    subclasses.
*/

/*
  Zipios++ - a small C++ library that provides easy access to .zip files.
  Copyright (C) 2000  Thomas Sndergaard
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
