#ifndef FCOLLEXCEPTIONS_H
#define FCOLLEXCEPTIONS_H

#include "zipios++/zipios-config.h"

#include <stdexcept>
#include <string>

namespace zipios {

using std::string ;
using std::exception ;

/** An IOException is used to signal an I/O error.
 */
class IOException : public exception {
public:
  IOException() noexcept ;
  explicit IOException( const string &msg ) noexcept ;
  IOException( const IOException &src ) noexcept ;
  IOException &operator= ( const IOException &src ) noexcept ;
  
  virtual const char *what() const noexcept ;
  virtual ~IOException() ;
private:
  string _what ;
};

/** An FCollException is used to signal a problem with a
 FileCollection. */
class FCollException : public exception {
public:
  FCollException() noexcept ;
  explicit FCollException( const string &msg ) noexcept ;
  FCollException( const FCollException &src ) noexcept ;
  FCollException &operator= ( const FCollException &src ) noexcept ;
  
  virtual const char *what() const noexcept ;
  virtual ~FCollException() ;
private:
  string _what ;
};

/** An object member function may throw this exception, if the
    operation it normally performs is inappropriate or impossible to
    perform because of the current state of the object. */
class InvalidStateException : public exception {
public:
  InvalidStateException() noexcept ;
  explicit InvalidStateException( const string &msg ) noexcept ;
  InvalidStateException( const InvalidStateException &src ) noexcept ;
  InvalidStateException &operator= ( const InvalidStateException &src ) noexcept ;
  
  virtual const char *what() const noexcept ;
  virtual ~InvalidStateException() ;
private:
  string _what ;
};

/** Basic exception */
class Exception : public exception {
public:
  Exception() noexcept ;
  explicit Exception( const string &msg ) noexcept ;
  Exception( const Exception &src ) noexcept ;
  Exception &operator= ( const Exception &src ) noexcept ;
  
  virtual const char *what() const noexcept ;
  virtual ~Exception() ;
private:
  string _what ;
};


} // namespace
#endif

/** \file
    Header file that defines a number of exceptions used by FileCollection and
    its subclasses.
*/

/*
  Zipios++ - a small C++ library that provides easy access to .zip files.
  Copyright (C) 2000  Thomas Sndergaard
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
