# coding=utf-8
import os

from suffix_trees import STree

ex = '''com.yandex.mail.notifications.NotificationService$CreateNotificationBundle.create
io.reactivex.internal.functions.Functions$Array2Func.apply
io.reactivex.internal.operators.single.SingleZipArray$ZipSingleObserver.io.reactivex.internal.operators.single.SingleZipArray$ZipCoordinator.innerSuccess
io.reactivex.internal.operators.single.SingleSubscribeOn$SubscribeOnObserver.onSuccess
io.reactivex.internal.operators.flowable.FlowableElementAtSingle$ElementAtSubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableMap$MapSubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableSwitchMap$SwitchMapSubscriber.drain
io.reactivex.internal.operators.flowable.FlowableSwitchMap$SwitchMapInnerSubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableMap$MapSubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableConcatArray$ConcatArraySubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableCreate$LatestAsyncEmitter.drain
io.reactivex.internal.operators.flowable.FlowableCreate$LatestAsyncEmitter.onNext
com.pushtorefresh.storio3.operations.internal.FlowableOnSubscribeExecuteAsBlocking.subscribe
io.reactivex.internal.operators.flowable.FlowableCreate.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableConcatArray$ConcatArraySubscriber.onComplete
io.reactivex.internal.operators.flowable.FlowableConcatArray.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableMap.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableMap.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableSwitchMap$SwitchMapSubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableConcatArray$ConcatArraySubscriber.onNext
io.reactivex.internal.operators.flowable.FlowableCreate$LatestAsyncEmitter.drain
io.reactivex.internal.operators.flowable.FlowableCreate$LatestAsyncEmitter.onNext
com.pushtorefresh.storio3.operations.internal.FlowableOnSubscribeExecuteAsBlocking.subscribe
io.reactivex.internal.operators.flowable.FlowableCreate.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableConcatArray$ConcatArraySubscriber.onComplete
io.reactivex.internal.operators.flowable.FlowableConcatArray.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableSwitchMap.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableMap.subscribeActual
io.reactivex.Flowable.subscribe
io.reactivex.internal.operators.flowable.FlowableElementAtSingle.subscribeActual
io.reactivex.Single.subscribe
io.reactivex.internal.operators.single.SingleSubscribeOn$SubscribeOnObserver.run
io.reactivex.Scheduler$DisposeTask.run
io.reactivex.internal.schedulers.ScheduledRunnable.run
io.reactivex.internal.schedulers.ScheduledRunnable.call
java.util.concurrent.FutureTask.run
java.util.concurrent.ScheduledThreadPoolExecutor$ScheduledFutureTask.run
'''

ex2 = '''
java.lang.RuntimeException: An error occurred while executing doInBackground()
	at android.os.AsyncTask$3.done(AsyncTask.java:309)
	at java.util.concurrent.FutureTask.finishCompletion(FutureTask.java:354)
	at java.util.concurrent.FutureTask.setException(FutureTask.java:223)
	at java.util.concurrent.FutureTask.run(FutureTask.java:242)
	at android.os.AsyncTask$SerialExecutor$1.run(AsyncTask.java:234)
	at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1113)
	at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:588)
	at java.lang.Thread.run(Thread.java:818)
Caused by: android.database.sqlite.SQLiteConstraintException: UNIQUE constraint failed: accounts.uid (code 2067)
	at android.database.sqlite.SQLiteConnection.nativeExecuteForLastInsertedRowId(Native Method)
	at android.database.sqlite.SQLiteConnection.executeForLastInsertedRowId(SQLiteConnection.java:797)
	at android.database.sqlite.SQLiteSession.executeForLastInsertedRowId(SQLiteSession.java:788)
	at android.database.sqlite.SQLiteStatement.executeInsert(SQLiteStatement.java:86)
	at android.database.sqlite.SQLiteDatabase.insertWithOnConflict(SQLiteDatabase.java:1505)
	at android.database.sqlite.SQLiteDatabase.insertOrThrow(SQLiteDatabase.java:1401)
	at com.pushtorefresh.storio3.sqlite.impl.DefaultStorIOSQLite$LowLevelImpl.insert(SourceFile:427)
	at com.yandex.mail.model.AccountModel.insertAccount(SourceFile:22807)
                                       insertAccount
	at com.yandex.mail.ui.presenters.AccountSwitcherPresenter.handleNewAccount(SourceFile:22272)
                                                           access$200
	at com.yandex.mail.ui.presenters.AccountSwitcherPresenter$1.runCallback(SourceFile:225)
	at com.yandex.mail.util.GetAuthTokenCallback$GetTokenAsyncTask.doInBackground$10299ca(SourceFile:97)
	at com.yandex.mail.util.GetAuthTokenCallback$GetTokenAsyncTask.doInBackground(SourceFile:52)
	at android.os.AsyncTask$2.call(AsyncTask.java:295)
	at java.util.concurrent.FutureTask.run(FutureTask.java:237)
	... 4 more
'''

def get_last_caused_by(ex_str):
    error_lines = ex_str.replace('\t', '').split('\n')
    start_line_num = 0
    for error_line in error_lines:
        if error_line.startswith('Caused by:'):
            start_line_num = error_lines.index(error_line)

    last_calls_stack = error_lines[start_line_num:]
    new_last_calls_stack = list()
    for line in last_calls_stack:
        new_line = line.strip().replace('Caused by: ', '')
        source_file_open_brace_index = -1
        source_file_close_brace_index = -1
        try:
            source_file_open_brace_index = new_line.index('(')
            source_file_close_brace_index = new_line.index(')')
        except:
            pass

        if source_file_open_brace_index != -1 and source_file_close_brace_index != -1 and 'at ' in new_line:
            source_file_with_line_num = new_line[source_file_open_brace_index:source_file_close_brace_index + 1]
            new_line = new_line.replace(source_file_with_line_num, '')
        if 'at ' in new_line:
            new_line = new_line.replace('at ', '')
        if '...' in new_line and ' more' in new_line:
            continue
        if 'Lambda$' in new_line or 'lambda$' in new_line:
            continue
        if '.' in new_line:
            new_last_calls_stack.append(new_line)

    if len(new_last_calls_stack) > 0 and ':' in new_last_calls_stack[0]:
        new_last_calls_stack[0] = new_last_calls_stack[0].split(':')[0]
        # remove message from first line
    return new_last_calls_stack

def transform_to_line_numbers(ai_list, line_boundaries):
    new_ai_list = list()
    for ai_item in ai_list:
        line_boundary_start = 0
        for line_boundary_index in range(len(line_boundaries)):
            if ai_item in range(line_boundary_start, line_boundaries[line_boundary_index]):
                new_ai_list.append(line_boundary_index)
            line_boundary_start = line_boundaries[line_boundary_index]
    return new_ai_list

def remove_recursion(stacktrace_str):
    st = STree.STree(stacktrace_str)
    a_list = stacktrace_str.splitlines(True)
    line_boundaries = st.find_all('\n')
    line_boundaries.sort()
    n = len(a_list)
    # бежим по всем фреймам
    lines_to_skip = set()
    for current_frame_index in range(0, n):
        # текущий проверяемый фрейм
        aj = a_list[current_frame_index]
        cur_frame_match_indexes = transform_to_line_numbers(st.find_all(aj),
                                                            line_boundaries)  # индексы где встречается aj - i1,i2,..,ik
        # в ai_list номера строк где найден фрейм aj
        cur_frame_match_indexes = filter(lambda x: x >= current_frame_index, cur_frame_match_indexes)
        if len(cur_frame_match_indexes) == 0:
            continue
        cur_frame_match_indexes.sort()
        first_match_index = current_frame_index
        cur_frame_match_indexes.pop(0)
        if len(cur_frame_match_indexes) > 0:
            # список фреймов которые проверяем на рекурсивность
            if len(cur_frame_match_indexes) == 1:
                max_recursion_depth = n - cur_frame_match_indexes[-1]
            else:
                max_recursion_depth = min(cur_frame_match_indexes[1] - cur_frame_match_indexes[0],
                                          n - cur_frame_match_indexes[-1])
            recursion_depth = 0
            while recursion_depth < max_recursion_depth:
                for cur_frame_match_index in range(0, len(cur_frame_match_indexes)):
                    if a_list[cur_frame_match_indexes[cur_frame_match_index] + recursion_depth] == a_list[
                        first_match_index + recursion_depth] and \
                            cur_frame_match_indexes[cur_frame_match_index] == first_match_index + recursion_depth + 1:
                        lines_to_skip_list = range(cur_frame_match_indexes[cur_frame_match_index],
                                                   cur_frame_match_indexes[cur_frame_match_index] + recursion_depth + 1)
                        temp_lines_to_skip_set = set(lines_to_skip_list)
                        if not temp_lines_to_skip_set.intersection(lines_to_skip):
                            if len(lines_to_skip_list) > 0:
                                for line_to_skip_list in lines_to_skip_list:
                                    lines_to_skip.add(line_to_skip_list)
                    else:
                        break
                recursion_depth += 1

    if len(lines_to_skip) > 0:
        new_stacktrace = list()
        tmp_lines_to_skip = list(lines_to_skip)
        tmp_lines_to_skip.sort()
        for line_num in range(len(a_list)):
            if not line_num in tmp_lines_to_skip:
                new_stacktrace.append(a_list[line_num])
        return ''.join(new_stacktrace)
    else:
        return a_list


def trim_stractrace(stacktrace_list, number_of_frames_to_keep):
    true_number_of_frames_to_keep = min(len(stacktrace_list), number_of_frames_to_keep)
    return stacktrace_list[:true_number_of_frames_to_keep]


def deobfuscate(dir_with_obfuscated):
    for filename in os.listdir(dir_with_obfuscated):
        if filename.startswith("android_crash"):
            full_file_path = os.path.join(dir_with_obfuscated, filename)
            p = os.subprocess.Popen(['java', '-jar', 'retrace.jar', 'mapping.txt', full_file_path], stdout=os.subprocess.PIPE, stderr=os.subprocess.PIPE)
            out, err = p.communicate()
            extension = 'txt'
            if len(err) > 0:
                extension = 'err'
            with open(os.path.join('deobfuscated', '{}.{}'.format(filename.replace('txt', ''), extension)), 'w+') as deobf_trace:
                deobf_trace.write(out)


def preprocess_stacktrace(stacktrace, trim_size, caused_by_num):
    preprocessed1 = get_last_caused_by(stacktrace)
    without_recursion = remove_recursion('\n'.join(preprocessed1))
    trimmed = trim_stractrace(without_recursion, trim_size)
    return ''.join(trimmed)

def main():
    # Для всех символов в стектрейсе находим индексы где данные символы встречаются, получаем множество индексов (1..j)
    #   для всех m от 2 до i-1 проверяем равны ли символы a в индексах m и j+(m-i). Если условие выполняется - нашли рекурсивный паттерн
    preprocessed1 = get_last_caused_by(ex2)
    # print('\n'.join(preprocessed1))
    without_recursion = remove_recursion('\n'.join(preprocessed1))
    trimmed = trim_stractrace(without_recursion, 15)
    print(''.join(trimmed))



if __name__ == '__main__':
    main()

# # Препроцессинг стектрейса - убираем весь лишний мусор, а именно
# # Убираме имя файла, оставляем только номер строки
# # Убираем at, убираем more, удаляем строки с лямбдами и слишком короткие строки
# # Вырезаем сообщение об ошибке и оставляем в вершине стека только сам эксепшн без описания
# def get_last_caused_by(ex_str):
#     error_lines = ex_str.replace('\t', '').split('\n')
#     start_line_num = 0
#     for error_line in error_lines:
#         if error_line.startswith('Caused by:'):
#             start_line_num = error_lines.index(error_line)
#
#     last_calls_stack = error_lines[start_line_num:]
#     new_last_calls_stack = list()
#     for line in last_calls_stack:
#         new_line = line.strip().replace('Caused by: ', '')
#         source_file_open_brace_index = -1
#         source_file_close_brace_index = -1
#         try:
#             source_file_open_brace_index = new_line.index('(')
#             source_file_close_brace_index = new_line.index(')')
#         except:
#             pass
#
#         if source_file_open_brace_index != -1 and source_file_close_brace_index != -1 and 'at ' in new_line:
#             source_file_with_line_num = new_line[source_file_open_brace_index:source_file_close_brace_index + 1]
#             source_file_and_line_num_splitted = source_file_with_line_num.replace('(', '').replace(')', '').split(':')
#             line_num = None
#             if len(source_file_and_line_num_splitted) > 1:
#                 line_num = source_file_and_line_num_splitted[1]
#             new_line = new_line.replace(source_file_with_line_num, '')
#             # if line_num and int(line_num) > 0:
#             #     new_line = new_line + '({})'.format(line_num)
#         if 'at ' in new_line:
#             new_line = new_line.replace('at ', '')
#         if '...' in new_line and ' more' in new_line:
#             continue
#         if 'Lambda$' in new_line or 'lambda$' in new_line:
#             continue
#         if '.' in new_line:
#             new_last_calls_stack.append(new_line)
#
#     if len(new_last_calls_stack) > 0 and ':' in new_last_calls_stack[0]:
#         new_last_calls_stack[0] = new_last_calls_stack[0].split(':')[0]
#         # remove message from first line
#
#     without_recursion = [e for (i, e) in enumerate(new_last_calls_stack) if i == 0 or e != new_last_calls_stack[i - 1]]
#     return '\n'.join(without_recursion)


# print('-----------------------------')
# print('\n'.join(remove_repeats(get_last_caused_by(ex).splitlines())))
# print('-----------------------------')
