#!/bin/bash

DIR="/usr/local/www/yandex-currency-rate/rates"

# Время прошедщее с момента обновления файлов:
TIMEOUT_LIMIT=$((60*6))
FILES_COUNT_LIMIT=1000

files_count=$(find $DIR -type f | wc -l)
old_files=$(find $DIR -type f -mmin +$TIMEOUT_LIMIT | wc -l)

if [ $old_files -gt 0 ]; then
	echo "2;There're "$old_files" old files"
	exit 0
fi

if [ $files_count -lt $FILES_COUNT_LIMIT ]; then
	echo "2;Too few files: "$files_count
	exit 0
fi

echo "0; Recent files: "$files_count
