freeStyleJob('build-aqua') {
    description('Сборка aqua тестов для проектов Доставки')

    label('maildev')

    logRotator(-1, 30)

    jdk('(System)')

    wrappers {
        timestamps()
        preBuildCleanup()
        sshAgent('robot-gerrit-ssh-key')
    }

    concurrentBuild(false)

    scm {
        svn {
            location('svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/mail/java/mx') {
                credentials('robot-gerrit-ssh-key')
                directory('.')
                depth(SvnDepth.INFINITY)
            }
            checkoutStrategy(SvnCheckoutStrategy.CHECKOUT)
        }
    }

    steps {
        maven {
            goals('clean install deploy -P production,aqua-report,aqua-report-archive')
            providedGlobalSettings('global-yandex-settings-xml')
            mavenInstallation('mvn')
            rootPOM('pom.xml')
        }
    }
}
