freeStyleJob('build-docker') {
    description('Сборка docker-образа для проектов Доставки')

    label('maildev')

    logRotator(-1, 30)

    parameters {
        stringParam('JIRA_TASKS', '', 'Jira task numbers, separated by space. For example: "MPROTO-1991"')
        stringParam('REVIEW_ID', '', 'Arcanum review id, e.g. 2018132')
        stringParam('PACKAGE_NAME', '', 'Package name, e.g. package_name')
        booleanParam('DEBUG', false, 'Release or debug version')
        booleanParam('ONLY_BUILD', false, 'Only build or build with push package')
        stringParam('REVISION', 'HEAD', 'Arcanum revision, e.g. 8569782')
        activeChoiceParam('PROJECT') {
            description('Delivey project')
            choiceType('RADIO')
            groovyScript {
                script('return [\'nwsmtp:selected\', \'notsolitesrv\', \'mdbsave\', \'furita\', \'ratesrv\', \'settings\']')
                fallbackScript('')
            }
        }
    }

    concurrentBuild(true)

    wrappers {
        buildName('[\${JIRA_TASKS}] \${PROJECT}')
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
        timestamps()
        timeout {
            absolute(30)
        }
    }

    environmentVariables {
        env('USERNAME', 'robot-gerrit')
        env('BUILD_RESULT', '!!(red)fail!!')
        env('PACKAGE_VERSION', '')
    }

    steps {
        shell(readFileFromWorkspace('build_docker.sh'))
        environmentVariables {
            propertiesFile('build.properties')
        }
    }

    publishers {
        updateStartrekIssues {
            byIssuesSeparated('${JIRA_TASKS}', '\\s')
            addComment("build \${PROJECT} \${BUILD_RESULT} **\${PACKAGE_VERSION}** ((https://common.jenkins.mail.yandex.net/job/build-docker/\${BUILD_ID}/console console))")
        }
    }
}
