set -ex

printenv

BUILD_FLAGS="-r --strip"

if [ -z "$PROJECT" ]; then
    exit 1
fi

if [ -z "$PACKAGE_NAME" ]; then
    PACKAGE_NAME="$(echo $JIRA_TASKS | tr -s " " "_")"
fi

if [ -n "$PACKAGE_NAME" ]; then
    PACKAGE_NAME=".$PACKAGE_NAME"
fi

if [ "$DEBUG" = "true" ]; then
    PACKAGE_NAME="$PACKAGE_NAME.debug"
    BUILD_FLAGS="-d"
fi

cd $WORKSPACE

mkdir -p arcadia store

arc_shared_store=${HOME}/.delivery/arc_store
if [ ! -d $arc_shared_store ]; then
    mkdir -p $arc_shared_store
fi

arc mount -m arcadia/ -S store/ --object-store ${arc_shared_store} &> /dev/null

cd arcadia

if [ "$REVISION" != "HEAD" ]; then
    arc checkout "r$REVISION" &> /dev/null
fi

if [ -n "$REVIEW_ID" ]; then
    arc pr checkout $REVIEW_ID &> /dev/null
fi

if [ -n "$CACHE_DIR" ]; then
    BUILD_FLAGS+=" --build-dir=$CACHE_DIR"
fi

PACKAGE_VERSION="$(date +%Y%m%d-%H%M).r$(arc info --json | jq .revision | tr -d ' ')$PACKAGE_NAME"

./ya package mail/$PROJECT/package/package.json --custom-version=$PACKAGE_VERSION $BUILD_FLAGS &> /dev/null

if [ "$ONLY_BUILD" != "true" ]; then
    docker build --pull --no-cache -t registry.yandex.net/mail/$PROJECT/$PROJECT:$PACKAGE_VERSION - < $PROJECT.$PACKAGE_VERSION.tar.gz &> /dev/null

    docker push registry.yandex.net/mail/$PROJECT/$PROJECT:$PACKAGE_VERSION &> /dev/null
fi

cd $WORKSPACE

mount | grep arc | awk '{print "arc unmount "$3}' | bash || true

echo "PACKAGE_VERSION=$PACKAGE_VERSION" > build.properties
echo "BUILD_RESULT=!!(green)successful!!" >> build.properties
