multiJob('night-build-for-caching') {
    description('Запуск ночных сборок для прогрева')

    label('maildev')

    logRotator(-1, 30)

    triggers {
        cron('0 2 * * *')
    }

    concurrentBuild(true)

    wrappers {
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
        timestamps()
        timeout {
            absolute(30)
        }
    }

    steps {
        phase('NIGHT BUILD') {
            for(i = 1; i <= 6; i++) {
                for (proj in ['nwsmtp', 'notsolitesrv']) {
                    phaseJob('build-docker') {
                        killPhaseCondition('NEVER')
                        parameters {
                            currentBuild()
                            nodeLabel('LABEL', 'maildev'+i+'.vla.yp-c.yandex.net')
                            predefinedProp('DEBUG', 'true')
                            predefinedProp('ONLY_BUILD', 'true')
                            predefinedProp('PROJECT', proj)
                            predefinedProp('CACHE_DIR', '/home/robot-gerrit/.ya/build_debug/')
                        }
                    }
                }
            }
        }
    }

}
