freeStyleJob('notsolitesrv-aqua') {
    description('Запуск системных aqua-тестов в QA окружении для для notsolitesrv')

    label('maildev')

    logRotator(-1, 30)

    parameters {
        stringParam('JIRA_TASKS', '', 'Стартрек задачи, разделенные пробелом. Например, "MPROTO-4081"')
        stringParam('TEST_HOST_NSLS', 'notsolitesrv-1.notsolitesrv.qa.notsolitesrv.mail.stable.qloud-d.yandex.net', 'notsolitesrv тестовый сервер')
    }

    concurrentBuild(true)

    wrappers {
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
        timestamps()
    }

    steps {
        aqua {
            timeout(30, 'MINUTES')
            parallel()

            packs {
                pack('5534d0a1e4b0914ed367cbbc') {
                    tag('${JIRA_TASKS}')
                    threshold(25)
                    prop('nsls.host', '${TEST_HOST_NSLS}')
                }
            }
        }
    }

    publishers {
        updateStartrekIssues {
            byIssuesSeparated('${JIRA_TASKS}', '\\s')
            addComment('((\${URL_AQUA_0} \${NAME_AQUA_0})) - OK: !!(green)**\${SUCCESS_AQUA_0}**!!, С ОШИБКАМИ: !!**\${FAIL_AQUA_0}**!!\n')
        }
    }
}
