freeStyleJob('nwsmtp-aqua') {
    description('Запуск системных aqua-тестов в QA окружении для nwsmtp')

    label('maildev')

    logRotator(-1, 30)

    parameters {
        stringParam('JIRA_TASKS', '', 'Стартрек задачи, разделенные пробелом. Например, "MPROTO-4081"')
        stringParam('TEST_HOST_MXFRONT', 'mxfront-1.mxfront.qa.nwsmtp.mail.stable.qloud-d.yandex.net', 'mxfront тестовый сервер')
        stringParam('TEST_HOST_MXBACK', 'mxback-1.mxback.qa.nwsmtp.mail.stable.qloud-d.yandex.net', 'mxback тестовый сервер')
        stringParam('TEST_HOST_YABACK', 'yaback-1.yaback.qa.nwsmtp.mail.stable.qloud-d.yandex.net', 'yaback тестовый сервер')
        stringParam('TEST_HOST_SMTP', 'smtp-1.smtp.qa.nwsmtp.mail.stable.qloud-d.yandex.net', 'smtp тестовый сервер')
    }

    concurrentBuild(true)

    wrappers {
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
        timestamps()
    }

    steps {
        aqua {
            timeout(30, 'MINUTES')
            parallel()

            packs {
                pack('52bd7c64e4b0e1f6fc96de6a') {
                    tag('${JIRA_TASKS}')
                    threshold(25)
                    prop('mx.server', '${TEST_HOST_MXBACK}')
                }
                pack('54f5b689e4b07e430307ee7e') {
                    tag('${JIRA_TASKS}')
                    threshold(25)
                    prop('mx.server', '${TEST_HOST_YABACK}')
                }
                pack('51dec6b484ae7d0209ab453f') {
                    tag('${JIRA_TASKS}')
                    threshold(25)
                    prop('mx.server', '${TEST_HOST_MXFRONT}')
                }
                pack('55f04128e4b05733565035e5') {
                    tag('${JIRA_TASKS}')
                    threshold(25)
                    prop('mx.server', '${TEST_HOST_SMTP}')
                }
                pack('574569aee4b09ee592750d3a') {
                    tag('${JIRA_TASKS}')
                    threshold(25)
                    prop('mx.server', '${TEST_HOST_MXBACK}')
                }
            }
        }
    }

    publishers {
        updateStartrekIssues {
            byIssuesSeparated('${JIRA_TASKS}', '\\s')
            addComment('((\${URL_AQUA_0} \${NAME_AQUA_0})) - OK: !!(green)**\${SUCCESS_AQUA_0}**!!, С ОШИБКАМИ: !!**\${FAIL_AQUA_0}**!!\n' +
        '((\${URL_AQUA_1} \${NAME_AQUA_1})) - OK: !!(green)**\${SUCCESS_AQUA_1}**!!, С ОШИБКАМИ: !!**\${FAIL_AQUA_1}**!!\n' +
        '((\${URL_AQUA_2} \${NAME_AQUA_2})) - OK: !!(green)**\${SUCCESS_AQUA_2}**!!, С ОШИБКАМИ: !!**\${FAIL_AQUA_2}**!!\n' +
        '((\${URL_AQUA_3} \${NAME_AQUA_3})) - OK: !!(green)**\${SUCCESS_AQUA_3}**!!, С ОШИБКАМИ: !!**\${FAIL_AQUA_3}**!!\n' +
        '((\${URL_AQUA_4} \${NAME_AQUA_4})) - OK: !!(green)**\${SUCCESS_AQUA_4}**!!, С ОШИБКАМИ: !!**\${FAIL_AQUA_4}**!!\n')
        }
    }
}
