freeStyleJob('nwsmtp-mxtests') {
    description('Запуск системных python-тестов в QA окружении для nwsmtp')

    label('mxtests.qa')

    logRotator(-1, 30)

    parameters {
        stringParam('JIRA_TASKS', '', 'Jira task numbers, separated by space. For example: "MPROTO-1991"')
        stringParam('EXTRA_RUN_PARAMS', '-B smtp -E qa --host smtp.qa.nwsmtp.mail.stable.qloud-d.yandex.net', 'Для запуска напротив определенного хоста')
        stringParam('RUN_COMMENT', '', 'Комментарий к запуску')
    }

    concurrentBuild(true)

    environmentVariables {
        env('LANG', 'en_US.UTF-8')
        env('MXTESTS_RESULT', '!!(red)FAIL!!')
    }

    wrappers {
        sshAgent('robot-gerrit-ssh-key')
        preBuildCleanup()
        timestamps()
    }

    steps {
        shell('''
        DATETIME=$(date +%Y-%m-%d-%H:%M:%S)
        RANDOM_ID=$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 8 | head -n 1)
        MXTESTS_TMP_DIR="/var/tmp/mxtests/"
        RUN_DIR=$MXTESTS_TMP_DIR$DATETIME"_"$RANDOM_ID
        echo "RUN DIR: "$RUN_DIR

        mkdir -p $MXTESTS_TMP_DIR
        cp -r /mxtests $RUN_DIR

        cd /$RUN_DIR

        export SSH_USER=robot-gerrit
        export USER=robot-gerrit

        ./mxtests -m pytest ${EXTRA_RUN_PARAMS} ./tests -n 4 -vv || 
        ./mxtests -m pytest ${EXTRA_RUN_PARAMS} ./tests -n 4 -vv --last-failed || 
        ./mxtests -m pytest ${EXTRA_RUN_PARAMS} ./tests -n 4 -vv --last-failed || 
        ./mxtests -m pytest ${EXTRA_RUN_PARAMS} ./tests -n 4 -vv --last-failed
        ''')

        conditionalSteps {
            condition {
                status('SUCCESS', 'SUCCESS')
            }
            steps {
                environmentVariables {
                    env('MXTESTS_RESULT', '!!(green)PASS!!')
                }
            }

        }
    }

    publishers {
        updateStartrekIssues {
            byIssuesSeparated('${JIRA_TASKS}', '\\s')
            addComment("\${MXTESTS_RESULT} ((https://common.jenkins.mail.yandex.net/job/nwsmtp-mxtests/\${BUILD_ID}/console console)) %%\${EXTRA_RUN_PARAMS}%% (\${RUN_COMMENT})")
        }
    }
}
