# Описание

**devpack** - фреймворк для локального запуска почтовых компонентов.
Он предназначен для использования при разработке и интеграционного тестирования микросервисов.
Он управляет различными компонентами, которые зависят друг от друга, умея запускать их локально и тушить обратно.

# Использование для разработки

Собираем CLI-утилиту и запускаем тесты.

```
$ cd ~/arcadia
$ ya make --checkout mail/devpack
$ ya make -ttt --checkout mail/devpack
```

Генерируем дефолтный конфиг. При желании конфиг можно поправить под себя.

```
$ cd mail/devpack/ctl
$ ./devpack gen_config
```

Запускаем все модули.

```
$ ./devpack start
```

Получаем информацию о развернутом окружении для дальнейшего использования.
```
$ ./devpack info
```

Если все окружение не нужно, можно запустить конкретный компонент с его зависимостями.
```
$ ./devpack stop
$ ./devpack start sharpei
```

При разработке конкретного микросервиса можно запустить все его зависимости (но не его самого).
После этого можно разрабатывать этот микросервис, используя запущенные зависимости.
```
$ ./devpack start mops --only-deps
$ ./devpack info
```

## Описание основных команд

* **gen_config** - генерирует дефолтный конфиг. У конфига есть дефолтное местоположение, но его можно переопределить при желании.
* **start** - запускает компонент(ы) и/или их зависимости. Происходит в несколько этапов: подготовка файлов, запуск демонов, подготовка простых тестовых данных.
* **stop** - останавливает компонент(ы) и/или их зависимости.
* **restart** - останавливает и запускает компонент(ы) и/или их зависимости.
* **purge** - останавливает компоненты и удаляет их данные с ФС.
* **info** - выводит информацию об окружении и отдельных компонентах.
* **interact** - запускает интерактивную IPython-консоль с загруженным объектом класса `Coordinator`, который содержит дерево компонентов с указанным корнем.
* **communicate** - интерактивное взаимодействие с компонентом, зависит от типа компонента. Например, для Postgre открывает psql к указанной базе.

Подробную справку об утилите и основных командах можно посмотреть, указав опцию `--help`:
```
$ ./devpack --help
...
$ ./devpack restart --help
...
```

# Использование для тестов

Есть два варианта использовать devpack в тестах для своего компонента.

## Свой компонент внутри `devpack`

Предполагается добавление своего компонента в общий ансамбль (см [инструкцию](#add-new)).
Это более предпочтительный вариант, т.к. коллеги смогут использовать новый компонент в общем ансамбле для своих тестов и разработки.

Когда компонент добавлен, можно использовать его нативно и проверять на различных запросах.

Пример кода теста:
```python
from yatest.common import network
from mail.devpack.lib.coordinator import Coordinator
from mail.devpack.lib.env import TestEnv
from mail.devpack.lib.components.sharpei import Sharpei

def test_sharpei_ping():
    pm = network.PortManager()
    coordinator = Coordinator(TestEnv(pm))
    coordinator.start(Sharpei)

    sharpei = coordinator.components[Sharpei]
    response = sharpei.ping()

    assert response.status_code == 200
    assert response.text == "pong"

    coordinator.stop(Sharpei)
    pm.release()
```

Примеры тестов для модулей, задействованных в общем ансамбле, можно найти в [tests/](tests).

## Свой компонент снаружи от `devpack`

Можно использовать `devpack` как внешнюю сущность. Это менее предпочтительный, но допустимый вариант,
если нужно сделать временные или ручные (`ya:manual`) тесты, или для быстрого прототипирования.

Алгоритм теста тогда будет выглядеть так:
* В коде своего теста поднимаем `devpack` с нужными модулями (метод `Coordinator.start(<класс модуля>)`)
* Достаем информацию о нужных зависимостях (например `coordinator.components[Mdb].port()`)
* Генерируем конфиг своего компонента с полученными параметрами
* Запускаем компонент и делаем в него тестовые запросы, проверяем поведение

<a name="add-new"/>

# Добавление новых компонентов

Чтобы добавить новый компонент в ансамбль devpack, нужно:

* создать в [lib/components](lib/components) новый python-модуль для управления компонентом.
Можно делать по аналогии с соседними модулями. Должен быть отнаследован от класса `BaseComponent`.
* добавить, если нужно, дефолтный порт(ы) для компонента в [генератор конфига](lib/config_master.py)
* если это конечная цель (от нее никто не зависит), нужно добавить его в зависимость компоненту [`All`](lib/components/all_dumb.py)
* если компонент - собираемый из нашего кода бинарь, то нужно добавить его в [список артефактов](lib/artifacts.inc) -
чтобы он автоматически собирался при запуске тестов или сборке CLI-утилиты `devpack`.
* написать базовый тест на проверку взаимодействия нового модуля с остальными. Лучше с глобальным окружением (fixture `devpack`), a не со своим отдельным - чтобы не замедлять тест.

# Известные gotchas

## Медленная работа

CLI-утилита `devpack` может работать медленно на openstack-виртуалках. Скорее всего это связано с медленными дисками в openstack.
Чтобы ускориться, можно в конфиге `devpack.yml` задать параметр `root`, ведущий на папку в шаренной памяти (например, внутри `/run/shm`).
Это позволит раза в 2 ускорить запуск окружения.

## localhost и IPv6

Некоторые демоны (например, `sharpei`), биндятся только к адресу `::1`.
Тогда запросы к адресу `localhost` через `curl` из консоли и `requests` из python могут фейлиться из-за ошибки в резолве.
Для корректной работы нужно либо слать запросы на `http://[::1]/my_query`, либо добавить в файл `/etc/hosts` строчку
```
::1 localhost
```

## ru_RU.UTF-8

Бинари, слинкованные с `butil` (например, `mops`), могут не стартовать, т.к. `butil` требует наличие в системе локали `ru_RU.UTF-8`.
На ubuntu ее можно добавить так:
```
$ sudo locale-gen ru_RU.UTF-8
$ sudo update-locale
```

# TODO

* добавить mulcagate и lenulca
* интеграция с [моком поиска по почте](https://a.yandex-team.ru/arc/trunk/arcadia/mail/search/mock)
* совместное использование с [pyremock](https://a.yandex-team.ru/arc/trunk/arcadia/library/python/testing/pyremock)
