from mail.devpack.lib.components.postgres import Postgres


class CalendarDb(Postgres):
    NAME = "calendardb"

    after_all_prefixes = [
        'resfs/file/mail/pg/calendardb/grants',
        'resfs/file/mail/devpack/sql'
    ]

    migration_prefixes = [
        'resfs/file/mail/pg/calendardb/migrations',
    ]

    snapshot_sql_files = [
        'resfs/file/mail/pg/calendardb/calendardb.sql',
    ]

    def __init__(self, env, _):
        users = [
            'calendar',
            'monitor'
        ]
        self.init_from_conf(env.get_config(), 'calendardb', users)
