from mail.devpack.lib.components.postgres_cluster import PostgresCluster


class CloudCluster(PostgresCluster):
    NAME = "cloud_cluster"

    def __init__(self, env, _):
        super(CloudCluster, self).__init__(env.get_config(), 'cloud', ['sharpei'], [])

    @classmethod
    def gen_config(cls, port_generator, config=None):
        port = next(port_generator)
        return {
            "shards": [{
                "name": "shard1",
                "id": 1,
                "dbs": [{
                    "type": "master",
                    "port": port
                }]
            }],
        }
