from future.standard_library import install_aliases
install_aliases()

from urllib.parse import urlencode
from fbb.app import FakeBlackBoxApp
from fbb.user_db import UserDBFromPG
from fbb.sessionid_db import SessionidDBFromPG
from .fbbdb import FbbDb
from .werkzeug_component import WerkzeugComponent


class FakeBlackbox(WerkzeugComponent):
    NAME = "fbb"
    DEPS = [FbbDb]

    @classmethod
    def gen_config(cls, port_generator, config=None):
        base = super(FakeBlackbox, cls).gen_config(port_generator, config=config)
        return dict(
            tvm={"client_id": next(port_generator)},
            **base
        )

    def __init__(self, env, components):
        self.is_corp = env.get_config()[self.name].get('is_corp', False)
        self.tvm_id = env.config['fbb']['tvm']['client_id']
        dsn = 'host=localhost port={port} dbname=fbbdb'.format(port=components[FbbDb].port())
        user_db = UserDBFromPG(dsn, self.is_corp)
        sessionid_db = SessionidDBFromPG(dsn)
        super(FakeBlackbox, self).__init__(env, components, app=FakeBlackBoxApp(user_db, sessionid_db))

    def prepare_data(self):
        self.register('test-login@yandex.ru')

    def info(self):
        return dict(
            is_corp=self.is_corp,
            **super(FakeBlackbox, self).info()
        )

    def save_sessionid(self, name, xml):
        url = '/save_sessionid?' + urlencode({'name': name})
        return self._request(url, data={'xml': xml})

    def register(self, login, **kwargs):
        args = {'login': login}
        if 'is_maillist' in kwargs:
            args['is_maillist'] = kwargs['is_maillist']

        args.update(kwargs)
        url = '/1/bundle/account/register/intranet/?' + urlencode(args)
        return self._request(url)

    def userinfo(self, login):
        args = {'method': 'userinfo', 'login': login, 'userip': '127.0.0.1'}
        url = '/blackbox?' + urlencode(args)
        return self._request(url)

    def sessionid(self, name):
        args = {'method': 'sessionid', 'userip': '127.0.0.1'}
        url = '/blackbox?' + urlencode(args)

        return self._request(url, data={'sessionid': name})
