import yaml
from library.python import resource
from mail.devpack.lib.components.postgres_cluster import PostgresCluster


class Mdb(PostgresCluster):
    NAME = "mdb"

    before_all_prefixes = [
        'resfs/file/mail/pg/mdb/constants',
        'resfs/file/mail/pg/mdb/common',
    ]

    migration_prefixes = [
        'resfs/file/mail/pg/mdb/migrations',
    ]

    after_all_prefixes = [
        'resfs/file/mail/pg/mdb/devpack/initdb.sql',
        'resfs/file/mail/pg/mdb/impl',
        'resfs/file/mail/pg/mdb/code/common',
        'resfs/file/mail/pg/mdb/code/contacts',
        'resfs/file/mail/pg/mdb/code/filters',
        'resfs/file/mail/pg/mdb/code/settings',
        'resfs/file/mail/pg/mdb/code/mailbox',
        'resfs/file/mail/pg/mdb/code/backup',
        'resfs/file/mail/pg/mdb/util',
        'resfs/file/mail/pg/mdb/grants',
        'resfs/file/mail/pg/mdb/devpack/prepare_doberman.sql',
        'resfs/file/mail/devpack/sql',
        'resfs/file/mail/pg/mdb/devpack/grants.sql',
    ]

    snapshot_sql_files = [
        'resfs/file/mail/pg/mdb/mail.sql',
        'resfs/file/mail/pg/mdb/filters.sql',
        'resfs/file/mail/pg/mdb/stats.sql',
        'resfs/file/mail/pg/mdb/settings.sql',
        'resfs/file/mail/pg/mdb/contacts.sql',
        'resfs/file/mail/pg/mdb/backup.sql',
    ]

    def __init__(self, env, _):
        users = [
            'maildb',
            'aceventura',
            'analytics',
            'collie',
            'cron',
            'doberman',
            'duty',
            'extractor',
            'furita',
            'imap',
            'mbody',
            'mobile',
            'monitor',
            'mops',
            'msearch',
            'mxback',
            'mxfront',
            'normal',
            'pop',
            'reader',
            'reg',
            'settings',
            'sharpei',
            'transfer',
            'web',
            'winmail',
            'xeno',
            'xiva',
            'barbet'
        ]

        super(Mdb, self).__init__(
            env.get_config(), 'maildb', users,
            self.before_all_prefixes + self.snapshot_sql_files + self.after_all_prefixes
        )

    @classmethod
    def gen_config(cls, port_generator, config=None):
        mdb_conf = resource.find("mdb/mdb.yml").decode('utf-8')
        mdb_conf = mdb_conf.format(port1=next(port_generator), port2=next(port_generator))
        return yaml.safe_load(mdb_conf)
