from fake_mulcagate.app import MulcagateApp

from .werkzeug_component import WerkzeugComponent


class Mulcagate(WerkzeugComponent):
    NAME = "mulcagate"

    def __init__(self, env, components):
        super(Mulcagate, self).__init__(env, components, app=MulcagateApp(), is_https=True)

    def list(self):
        return self._request("/_on_list")

    def describe(self):
        return self._request("/")

    def put(self, suid, data):
        return self._request("/gate/put/{suid}".format(suid=suid), data=data)

    def get(self, stid):
        return self._request("/gate/get/{stid}".format(stid=stid))

    def delete(self, stid):
        return self._request("/gate/del/{stid}".format(stid=stid))
