from .base import BaseComponent

from library.python.testing.pyremock.lib.pyremock import MockHttpServer


class PyremockComponent(BaseComponent):
    NAME = 'pyremock'

    @classmethod
    def gen_config(cls, port_generator, config=None):
        base = super(PyremockComponent, cls).gen_config(port_generator, config=config)
        return dict(
            port=next(port_generator),
            **base
        )

    @property
    def port(self):
        return self.config[self.name]['port']

    def __init__(self, env, components):
        super(PyremockComponent, self).__init__(env, components)
        self.__service = None

    def start(self):
        self.logger.info('starting %s on port %d', self.NAME, self.port)
        self.__service = MockHttpServer(self.port)
        self.__service.start()

    def stop(self):
        self.logger.info('stopping %s', self.NAME)
        self.__service.stop()

    def reset(self):
        self.logger.info('restarting %s on port %d', self.NAME, self.port)
        self.__service.reset()

    def expect(self, **kwargs):
        self.__service.expect(**kwargs)

    def assert_expectations(self):
        self.__service.assert_expectations()
