from mail.devpack.lib.components.postgres import Postgres


class ShardDb(Postgres):
    NAME = "sharddb"

    after_all_prefixes = [
        'resfs/file/mail/pg/sharddb/code',
        'resfs/file/mail/pg/sharddb/grants',
        'resfs/file/mail/devpack/sql',
    ]
    migration_prefixes = [
        'resfs/file/mail/pg/sharddb/migrations',
    ]
    snapshot_sql_files = [
        'resfs/file/mail/pg/sharddb/sharddb.sql',
    ]

    def __init__(self, env, _):
        users = [
            'monitor',
            'sharpei',
            'developer',
        ]
        self.__config = env.get_config()
        self.init_from_conf(self.config, 'sharddb', users)

    @property
    def config(self):
        return self.__config

    def prepare_data(self):
        super(ShardDb, self).prepare_data()
        instance_id = 1
        self.execute(
            '''select setval('shards.shard_s', %(shard_cnt)s)''',
            shard_cnt=len(self.config['mdb']['shards'])
        )
        for shard in self.config['mdb']['shards']:
            shard_name, shard_id = shard['name'], shard['id']
            self.execute(
                '''
                    INSERT INTO shards.shards (shard_id, name, reg_weight)
                    VALUES (%(shard_id)s, %(shard_name)s, %(reg_weight)s)
                ''',
                shard_id=shard_id,
                shard_name=shard_name,
                reg_weight=shard['reg_weight']
            )
            self.execute(
                '''
                    INSERT INTO shards.shards_load
                        (shard_id, can_transfer_to, load_average)
                    VALUES
                        (%(shard_id)s, true, 0)
                ''',
                shard_id=shard_id,
            )
            for db in shard['dbs']:
                self.execute(
                    '''
                        INSERT INTO shards.instances (instance_id, shard_id, host, port, dc, dbname)
                        VALUES (%(instance_id)s, %(shard_id)s, 'localhost', %(port)s, 'local', 'maildb')
                    ''',
                    instance_id=instance_id,
                    shard_id=shard_id,
                    port=db['port']
                )
                instance_id += 1
